# Offline Changepoint Detection With Gaussian Processes

This folder contains the code associated with the paper *Offline Changepoint Detection With Gaussian Processes*. In the paper, we introduced Segmenting Changepoint Gaussian Process regression, or SegCPGP, a method for offline, Gaussian process regression-based changepoint detection. Essentially, SegCPGP combines Gaussian process regression with binary search to detect multiple changepoints with unknown locations.
SegCPGP builds upon [GPFlow](https://gpflow.github.io/GPflow/2.9.1/index.html).

The folder `cpgp` contains `segcpgp.py`, which contains an implementation of the SegCPGP algorithm, and `spectralmixture.py`, which contains an implementation of the spectral mixture kernel (originally from [here](https://github.com/DavidLeeftink/Spectral-Discontinuity-Design/blob/master/SpectralMixture.py)). The file `demo.ipynb` contains a few examples of SegCPGP's use on mean and trend change datasets.

### Installation

1. Create a virtual environment with Python version 3.11.7.
2. Install `requirements.txt` into the environment via pip.
3. Run `demo.ipynb`.

We tested the installation on MacOS and Linux (Fedora 40).

### Running SegCPGP

In principle, SegCPGP can be imported from `cpgp/segcpgp.py` as a class, which you can then call `.fit()` on as you would do with a `scikit-learn` model. The most minimal example would be the following:

```python
import numpy 
from cpgp.segcpgp import SegCPGP

# This example data does not contain a changepoint.
X = np.linspace(0, 40, 100).reshape(-1, 1)
y = np.random.normal(size=100).reshape(-1, 1)

segcpgp = SegCPGP(pval=0.05)
segcpgp.fit(X, y)
```

By default, SegCPGP uses a [constant kernel](https://gpflow.github.io/GPflow/2.9.1/api/gpflow/kernels/index.html#gpflow.kernels.Constant), but in principle any valid kernel function implemented as an extension of GPFlow's Kernel class could be used.
