class Client:
    def __init__(
        self,
        client_idx,
        local_training_data,
        local_test_data,
        local_val_data,
        local_sample_number,
        args,
        device,
        model_trainer,
    ):
        self.client_idx = client_idx
        self.local_training_data = local_training_data
        self.local_test_data = local_test_data
        self.local_sample_number = local_sample_number
        self.local_val_data = local_val_data
        self.args = args
        self.device = device
        self.model_trainer = model_trainer

    def update_local_dataset(
        self, client_idx, local_training_data, local_test_data, local_val_data, local_sample_number
    ):
        self.client_idx = client_idx
        self.local_training_data = local_training_data
        self.local_val_data = local_val_data
        self.local_test_data = local_test_data
        self.local_sample_number = local_sample_number

    def get_sample_number(self):
        return self.local_sample_number

    def train(self, w_global):
        self.model_trainer.set_model_params(w_global)
        self.model_trainer.train(self.local_training_data, self.device, self.args)
        weights = self.model_trainer.get_model_params()
        return weights

    def local_test(self, b_use_test_dataset,b_use_val_dataset=False):
        if b_use_test_dataset:
            if b_use_val_dataset:
                test_data = self.local_val_data
            else:
                test_data = self.local_test_data
        else:
            test_data = self.local_training_data
        metrics, target_list, pred_list, s_list = self.model_trainer.test(test_data, self.device,self.args)
        return metrics, target_list, pred_list, s_list
