# Bias Propagation in Federated Learning

The folder contains the code for the submission. The essential environments are listed in the `environment.yml` file. The code is tested on `Python 3.8.13` and `cuda 11.4`.

The implementation of the FedAvg is in `fedavg` folder, and the implementation of other FL algorithms is in `other_fl`. Next, we give examples of how to run FedAvg algorithm.

To run federated learning on Income dataset, use the command:
```
python main.py --cf config/config_fedavg_income.yaml
```
Similarly, to run the centralized training, using the following command:
```
python main.py --cf config/config_centralized_income.yaml
```
Standalone training:
```
python main.py --cf config/config_standalone_income.yaml
```
We report the average results over five different runs. Thus, to reproduce the results, run the command five times with different random seeds, which is indicated by common_args.random_seed in the YAML file. 

To get the results on other datasets (e.g., Health dataset), run the ``main.py`` file with ``config/config_standalone_{dataset}.yaml``, where the dataset can be health, employment, or income.