import matplotlib.pyplot as plt
import numpy as np
from sklearn.preprocessing import LabelEncoder

def create_KDE_scatter_plots(ax, embeddings, labels):
    # Ensure labels are encoded
    label_encoder = LabelEncoder()
    encoded_labels = label_encoder.fit_transform(labels)
    
    # Define label names
    label_names = {0: 'Rise', 1: 'Neutral', 2: 'Fall'}
    
    # Define colors and markers for each label
    colors = ['red', 'blue', 'green']
    markers = ['o', 's', 'D']
    
    # Scatter plot for each class
    for label in np.unique(encoded_labels):
        class_embeddings = embeddings[encoded_labels == label]
        ax.scatter(class_embeddings[:, 0], class_embeddings[:, 1], 
                   c=colors[label], marker=markers[label], 
                   label=label_names[label], alpha=0.6, edgecolors='w', s=20)
    
    #ax.set_xlabel('Embedding Dimension 1')
    #ax.set_ylabel('Embedding Dimension 2')
    #ax.legend()
    ax.grid(True)