import yaml
import argparse

class Config:
    def __init__(self, config_file):
        with open(config_file, 'r') as file:
            self.config = yaml.safe_load(file)

    def get(self, section, key, default=None):
        return self.config.get(section, {}).get(key, default)

    def __getitem__(self, item):
        return self.config[item]
    
    def to_dict(self):
        return dict(self.config)

def parse_args():
    parser = argparse.ArgumentParser(description='PyTorch Lightning Project')
    parser.add_argument('--config', type=str, required=True, help='Path to the config file')
    return parser.parse_args()

def load_config():
    args = parse_args()
    config = Config(args.config)
    return config

config = load_config()