#!/usr/bin/env python
import io
import os
import re
from datetime import datetime

from setuptools import find_packages, setup


def read(*names, **kwargs):
    with io.open(os.path.join(os.path.dirname(__file__), *names),
                 encoding=kwargs.get("encoding", "utf8")) as fp:
        return fp.read()


def find_version(*file_paths):
    version_file = read(*file_paths)
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]", version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")


VERSION = find_version('src', 'prediff', '__init__.py')

if VERSION.endswith('dev'):
    VERSION = VERSION + datetime.today().strftime('%Y%m%d')

requirements = [
    'pytorch-lightning==1.9.0',
    'torchmetrics',
    'yacs',
    'omegaconf',
    'scipy',
    'scikit-learn',
    'ninja',
    'pillow',
    'opencv-python',
    'imageio',
    'matplotlib',
    'tensorboard',
    'einops',
    'diffusers==0.13.0',
    'taming-transformers==0.0.1',
]

setup(
    # Metadata
    name='prediff',
    version=VERSION,
    python_requires='>=3.9',
    description='Official implementation in PyTorch-Lightning of PreDiff: Precipitation Nowcasting with Latent Diffusion Models',
    long_description_content_type='text/markdown',
    license='Apache-2.0',
    # Package info
    packages=find_packages(where="src", exclude=(
        'scripts',
        'tests',
        'datasets',
    )),
    package_dir={"": "src"},
    zip_safe=True,
    include_package_data=True,
    install_requires=requirements,
)
