# Optimal Online Change Detection via Random Fourier Features

This repository collects the python code for replicating the experiments and figures of the article:

- F. Kalinke* and S. Gavioli-Akilagun* (*Equal contribution). Optimal Online Change Detection via Random Fourier Features. Advances in Neural Information Processing Systems (NeurIPS), 2025.

Of independent interest are our implementations of the following.

- Our proposed random Fourier feature-based change detection algorithm.
- A python implementation of [Online Kernel CUSUM](https://arxiv.org/abs/2211.15070), complementing the existing [MATLAB implementation](https://github.com/SongWei-GT/online_kernel_cusum/).
- A python implementation of [Scan B-statistics](https://arxiv.org/abs/1507.01279).

## Dependencies 

Install the required dependencies with the following command (assuming [uv](https://docs.astral.sh/uv/)).

    uv sync

## Usage example

Use the following code to find changes in a (simulated) stream of two-dimensional data.

```python
import numpy as np
from online_rff_mmd import kernel

rng = np.random.default_rng(1234)
X = rng.normal(size=(256,2)) 
Y = rng.normal(loc=2,size=(256,2)) # different mean -> change
gauss = kernel.Gauss(gamma=kernel.Gauss.est_gamma(X))
cd = kernel.StreamingRFFMMD(gauss,d=2,num_omegas=1000)
for i, elem in enumerate(np.concatenate((X,Y))):
    cd.insert(elem)
    if cd.has_change(min_arl=1000): # number of elements to process (at least) under the null (no change)
        print("Change detected after processing ", i, " elements.")
        break
```

## Experiments 

All code for the experiments on synthetic and MNIST data is in [src/online_rff_mmd/experiments/](src/online_rff_mmd/experiments/). Run these experiments with

    sh run_experiments_synth.sh # reproduce the synthetic results
    sh run_experiments_mnist.sh # reproduce the MNIST results
    python src/online_rff_mmd/experiments/edd_distribution_free.py # reproduce the distribution-free MNIST results
    python src/online_rff_mmd/experiments/runtime.py # reproduce the runtime results

The code for running the HASC and Mazurka experiments is in the respective notebooks in the `notebooks/` folder.


## Figures

For the figures, see [notebooks/](notebooks/).


## Tests

Run the tests with `python -m pytest`.