import seaborn as sns

def get_sns_conf(algorithms):
    """

    Usage example
    =============

    algorithms = ["Algorithm 1", "Algorithm 2", "Algorithm 3"]
    labels = algorithms
    sns_conf = get_sns_conf(algorithms=algorithms)

    df = df.sort_values("Algorithm")
    
    fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(8,2.3))

    sns.lineplot(data=df, x="n", y="Estimate", hue="Algorithm", ax=ax1, style="Algorithm", **sns_conf)

    line, _ = ax1.get_legend_handles_labels()
    fig.legend(line, labels, loc="upper center", bbox_to_anchor=(0.53, 1.13), ncol=3)

    """
    possible_markers = ["*", "d", "X", "P", "o", "v", "^", "p", ">", "<"]
    n = min(len(algorithms),len(possible_markers))

    palette_sns = sns.color_palette("Set1", n_colors=n)
    palette_sns = [palette_sns[i] for i in range(n)]

    markers = { k:v for k,v in  zip(algorithms[:n], possible_markers)}
    palette = { k:v for k,v in zip(algorithms, palette_sns) }
    return { "palette" : palette, "markers" : markers, "hue_order" : algorithms }