import sys; sys.path.append(".."); sys.path.append("./src")
import numpy as np
import kernel, util
from tqdm import tqdm
import pandas as pd

rng = np.random.default_rng(1234)

## config
runs = 10
lengths = 2**np.arange(7,19)
omegas = [10, 50, 100, 500, 1000]
d = 1
output = "results/runtimes.csv"

if __name__ == "__main__":
    results = pd.DataFrame()

    for _ in tqdm(range(runs)):
        for num_omega in omegas:
            for l in reversed(lengths):
                X = rng.normal(size=(l,d))
                cd = kernel.StreamingRFFMMD(kernel=kernel.Gauss(gamma=1),d=d,num_omegas=num_omega)
                with util.ContextTimer() as t:
                    for e in X:
                        cd.insert(e)
                        cd.mmd_values()
                results = pd.concat((results,pd.DataFrame({"l" : [l], 
                                                        "total" : [t.secs],
                                                        "per_insert" : [t.secs / l],
                                                        "r" : [num_omega]})))
                
    results.to_csv(output)