import json


class MergingAgent():
    def __init__(self, llm):
        self.llm = llm

    def merge(self, query, subqueries, subknowledges, chosen, data_id):
        print(f"data_id: {data_id}, do_merge...")

        retrieval_of_chunk = ""
        retrieval_of_graph = ""
        retrieval_of_table = ""
        retrieval_of_algorithm = ""
        retrieval_of_catalogue = ""

        if chosen == "chunk":
            subknowledges = "\n".join(subknowledges)
            retrieval_of_chunk += f"Subquery: {query}\nRetrieval results:\n{subknowledges}\n\n"
        elif chosen == "table":
            for subquery, subknowledge in zip(subqueries, subknowledges):
                retrieval_of_table += f"Subquery: {subquery}\nRetrieval results:\n{subknowledge}\n\n"
        elif chosen == "graph":
            for subquery, subknowledge in zip(subqueries, subknowledges):
                retrieval_of_graph += f"Subquery: {subquery}\nRetrieval results:\n{subknowledge}\n\n"
        elif chosen == "algorithm":
            for subquery, subknowledge in zip(subqueries, subknowledges):
                retrieval_of_algorithm += f"Subquery: {subquery}\nRetrieval results:\n{subknowledge}\n\n"
        elif chosen == "catalogue":
            subknowledges = "\n".join(subknowledges)
            retrieval_of_catalogue += f"Subquery: {query}\nRetrieval results:\n{subknowledges}\n\n"
        else:
            raise ValueError("chosen should be in ['chunk', 'table', 'graph', 'algorithm', 'catalogue']")

        if self.nead_complex_merging_method:
            raw_prompt = open("agents/prompts/merging_5_type.txt", "r").read()
            prompt = raw_prompt.format(
                query=query, 
                retrieval_of_chunk=retrieval_of_chunk,
                retrieval_of_graph=retrieval_of_graph,
                retrieval_of_table=retrieval_of_table,
                retrieval_of_algorithm=retrieval_of_algorithm,
                retrieval_of_catalogue=retrieval_of_catalogue
            )
            output = self.llm.response(prompt)
            print(f"output of merge: {output}")
            output = output.strip("```").strip('json').strip()

            answer_start = output.find('"answer": ')
            answer_end = answer_start + len('"answer": ')
            decision_start = output.find('"decision": ')
            decision_end = decision_start + len('"decision": ')
            new_query_start = output.find('"new_query": ')
            new_query_end = new_query_start + len('"new_query": ')
            answer = output[answer_end:decision_start].strip().strip('"').strip(',')
            decision = output[decision_end:new_query_start].strip().strip('"').strip(',')
            new_query = output[new_query_end:].strip().strip('"').strip(',')

            if "CONTINUE" in decision:
                decision = "CONTINUE"
        else:
            decision = "No"
            new_query = "No"
            instruction = "1. Answer the Question based on retrieval results. \n2. Find the relevant information from given retrieval results and output as detailed, specific, and lengthy as possible. \n3. The output must be a coherent and smooth piece of text."
            prompt = f"Instrion:\n{instruction}\n\nQuestion:\n{query}\n\nRetrieval:\n{retrieval_of_chunk}{retrieval_of_graph}{retrieval_of_table}{retrieval_of_algorithm}{retrieval_of_catalogue}"

        answer = self.llm.response(prompt)

        return answer, decision, new_query