import torch
import numpy as np
import pdb
from sklearn.neighbors import NearestNeighbors
import pickle
from datetime import datetime
from sklearn.metrics import pairwise_distances
from torch.utils.data import DataLoader
import pickle
from scipy.spatial.distance import cosine
import sys
import gc
from scipy.linalg import det
from scipy.linalg import pinv as inv
from copy import copy as copy
from copy import deepcopy as deepcopy
from torch.utils.data import DataLoader, TensorDataset
from torch import nn
import torchfile
from torch.autograd import Variable
import resnet
import vgg
import torch.optim as optim
import pdb
from torch.nn import functional as F
import argparse
import torch.nn as nn
from collections import OrderedDict
from scipy import stats
import numpy as np
import scipy.sparse as sp
from itertools import product
from sklearn.base import BaseEstimator, ClusterMixin, TransformerMixin
from sklearn.metrics.pairwise import euclidean_distances
from sklearn.metrics.pairwise import pairwise_distances_argmin_min
from sklearn.utils.extmath import row_norms, squared_norm, stable_cumsum
from sklearn.utils.sparsefuncs_fast import assign_rows_csr
from sklearn.utils.sparsefuncs import mean_variance_axis
from sklearn.utils.validation import _num_samples
from sklearn.utils import check_array
from sklearn.utils import gen_batches
from sklearn.utils import check_random_state
from sklearn.utils.validation import check_is_fitted
from sklearn.utils.validation import FLOAT_DTYPES
from sklearn.metrics.pairwise import rbf_kernel as rbf
from sklearn.exceptions import ConvergenceWarning
from sklearn.metrics import pairwise_distances

def uniform(cont_model, dataset):
    
    idxs_lambdas_descending = (-cont_model.lambdas).argsort()
    samples_per_task = cont_model.args.buffer_size // dataset.N_TASKS # e.g: 200 with bufsize = 1000
    samples_per_class = cont_model.args.buffer_size // (2*(cont_model.task+1)) # e.g: 100
    num_outliers = 100
    
    if cont_model.buffer.is_empty():

        assert cont_model.buffer.buffer_size + num_outliers < len(idxs_lambdas_descending) , "Tried to add duplicates to buffer."

        imgs, targets = [], []

        space_per_class = np.zeros(dataset.N_CLASSES_PER_TASK*dataset.N_TASKS) 
        space_per_class[:dataset.N_CLASSES_PER_TASK] += samples_per_class

        for i in idxs_lambdas_descending[num_outliers:]:
            img, target, original_img, index = dataset.train_loader.dataset[i]
            if space_per_class[target] > 0:
                imgs.append(original_img.unsqueeze(0))
                targets.append(target)
                space_per_class[target] -= 1
            if np.sum(space_per_class) == 0:
                break
    else:

        # Get all buffer
        all_data = cont_model.buffer.get_all_data(transform = None)

        # Empty old buffer to replace with new one
        cont_model.buffer.empty()

        # Get samples from new task
        imgs, targets = [], []
        
        space_per_class = np.zeros(dataset.N_CLASSES_PER_TASK*dataset.N_TASKS) 
        space_per_class[cont_model.task*dataset.N_CLASSES_PER_TASK:cont_model.task*dataset.N_CLASSES_PER_TASK+dataset.N_CLASSES_PER_TASK] += samples_per_class

        for i in idxs_lambdas_descending[num_outliers:]:
            img, target, original_img, index = dataset.train_loader.dataset[i]
            if space_per_class[target] > 0:
                imgs.append(original_img.unsqueeze(0))
                targets.append(target)
                space_per_class[target] -= 1
            if np.sum(space_per_class) == 0:
                break     

        # Get samples from buffer randomly but uniformly
        examples, labels = all_data
        random_idxs = np.arange(len(labels))
        np.random.shuffle(random_idxs)
        
        space_per_class = np.zeros(dataset.N_CLASSES_PER_TASK*dataset.N_TASKS) 
        space_per_class[:cont_model.task*dataset.N_CLASSES_PER_TASK] += samples_per_class

        for i in random_idxs:
            if space_per_class[labels[i]] > 0:
                imgs.append(examples[i].unsqueeze(0))
                targets.append(labels[i])
                space_per_class[labels[i]] -= 1
            if np.sum(space_per_class) == 0:
                break

    return imgs, targets
    
# kmeans ++ initialization
def init_centers(X, K):
    ind = np.argmax([np.linalg.norm(s, 2) for s in X])
    mu = [X[ind]]
    indsAll = [ind]
    centInds = [0.] * len(X)
    cent = 0
    print('#Samps\tTotal Distance')
    while len(mu) < K:
        if len(mu) == 1:
            D2 = pairwise_distances(X, mu).ravel().astype(float)
        else:
            newD = pairwise_distances(X, [mu[-1]]).ravel().astype(float)
            for i in range(len(X)):
                if D2[i] >  newD[i]:
                    centInds[i] = cent
                    D2[i] = newD[i]
        print(str(len(mu)) + '\t' + str(sum(D2)), flush=True)
        if sum(D2) == 0.0: pdb.set_trace()
        D2 = D2.ravel().astype(float)
        Ddist = (D2 ** 2)/ sum(D2 ** 2)
        customDist = stats.rv_discrete(name='custm', values=(np.arange(len(D2)), Ddist))
        ind = customDist.rvs(size=1)[0]
        while ind in indsAll: ind = customDist.rvs(size=1)[0]
        mu.append(X[ind])
        indsAll.append(ind)
        cent += 1
    return indsAll

# gradient embedding for (assumes cross-entropy loss)
def get_grad_embedding(cont_model, X, Y):
    
    model = cont_model.backbone
    embDim = model.get_embedding_dim()
    model.eval()
    nLab = len(torch.unique(Y))
    embedding = torch.zeros([len(Y), embDim * nLab], requires_grad=False)
    
    loader = DataLoader(TensorDataset(X, Y), batch_size = 64, shuffle=False)
    with torch.no_grad():
        for x, y in loader:
            x, y = x.to(cont_model.device), y.to(cont_model.device)
            out, emb = model(x, returnt = 'all')
            batchProbs = F.softmax(out, dim=1).cpu()
            maxInds = torch.argmax(batchProbs, 1)
            for j in range(len(y)):
                for c in range(nLab):
                    if c == y[j]:
                        embedding[j][embDim * c : embDim * (c+1)] = deepcopy(out[j].cpu()) * (1 - batchProbs[j][c])
                    else:
                        embedding[j][embDim * c : embDim * (c+1)] = deepcopy(out[j].cpu()) * (-1 * batchProbs[j][c])
        return embedding


def coreset(cont_model, dataset):
    return None

def badge(cont_model, dataset):
    
    samples_per_task = cont_model.args.buffer_size // dataset.N_TASKS # e.g: 200 with bufsize = 1000
    samples_per_class = cont_model.args.buffer_size // (2*(cont_model.task+1)) # e.g: 100
    
    if cont_model.buffer.is_empty():

        imgs, targets = [], []

        space_per_class = np.zeros(dataset.N_CLASSES_PER_TASK*dataset.N_TASKS) 
        space_per_class[:dataset.N_CLASSES_PER_TASK] += samples_per_class

        dl = DataLoader(dataset.train_loader.dataset, batch_size=len(dataset.train_loader.dataset), shuffle=False)
        all_imgs, all_targets, all_original_imgs, all_indexes = next(iter(dl))

        for y in torch.unique(all_targets):
            
            y_imgs, y_targets, y_idxs = all_imgs[all_targets == y], all_targets[all_targets == y], all_indexes[all_targets == y] 
            gradEmbedding = get_grad_embedding(cont_model, y_imgs, y_targets)
            chosen = init_centers(gradEmbedding, space_per_class[int(y)])
            
            for i in y_idxs[chosen]:
                imgs.append(all_original_imgs[i].unsqueeze(0))
                targets.append(all_targets[i])
        
    else:

        # Get all buffer
        all_data = cont_model.buffer.get_all_data(transform = None)

        # Empty old buffer to replace with new one
        cont_model.buffer.empty()

        # Get samples from new task
        imgs, targets = [], []
        
        space_per_class = np.zeros(dataset.N_CLASSES_PER_TASK*dataset.N_TASKS) 
        space_per_class[cont_model.task*dataset.N_CLASSES_PER_TASK:cont_model.task*dataset.N_CLASSES_PER_TASK+dataset.N_CLASSES_PER_TASK] += samples_per_class

        dl = DataLoader(dataset.train_loader.dataset, batch_size=len(dataset.train_loader.dataset), shuffle=False)
        all_imgs, all_targets, all_original_imgs, all_indexes = next(iter(dl))

        for y in all_targets.unique():
            
            y_imgs, y_targets, y_idxs = all_imgs[all_targets == y], all_targets[all_targets == y], all_indexes[all_targets == y] 
            gradEmbedding = get_grad_embedding(y_imgs, y_targets)
            chosen = init_centers(gradEmbedding, space_per_class[int(y)])
            
            for i in y_idxs[chosen]:
                imgs.append(all_original_imgs[i].unsqueeze(0))
                targets.append(all_targets[i])
        
        # Get samples from buffer randomly but uniformly
        examples, labels = all_data
        random_idxs = np.arange(len(labels))
        np.random.shuffle(random_idxs)
        
        space_per_class = np.zeros(dataset.N_CLASSES_PER_TASK*dataset.N_TASKS) 
        space_per_class[:cont_model.task*dataset.N_CLASSES_PER_TASK] += samples_per_class

        for i in random_idxs:
            if space_per_class[labels[i]] > 0:
                imgs.append(examples[i].unsqueeze(0))
                targets.append(labels[i])
                space_per_class[labels[i]] -= 1
            if np.sum(space_per_class) == 0:
                break

    return imgs, targets