from math import cos, exp, pi, sin
from scipy.integrate import quad
import numpy as np

# Define functions


def psi_integral(x):
    return sin(pi * x) * exp(-sin(pi * x)**(-2))


def psi1(x):
    A = 0.141328
    ps1, _ = quad(psi_integral, 0, 1 + x)
    return np.sqrt((1 / A) * ps1)


def psi2(x):
    A = 0.141328
    ps2, _ = quad(psi_integral, 0, x)
    return np.sqrt((1 / A) * ps2)


def xi(x):
    return np.sin(np.pi * x) * np.exp(-(np.sin(np.pi * x))**(-2))

# call quad to integrate f from -2 to 2


def G1(x):
    A = 0.141328
    ps1_normalized = psi1(x)
    return (
        np.cosh(x) * ps1_normalized
        + np.sinh(x) * (xi(1 + x)) / (2 * A * np.sqrt(ps1_normalized))
    )


def G2(x):
    A = 0.141328
    ps2_normalized = psi2(x)
    return (
        np.cosh(x) * ps2_normalized
        + np.sinh(x) * (xi(x)) / (2 * A * np.sqrt(ps2_normalized))
    )


def calculate_c(resolution=1e-8):
    c = -np.inf
    iteration = 0
    for x in np.arange(-2, 2, resolution):
        if G1(x) > G2(x):
            c_i = 2 * G1(x)
        else:
            c_i = 2 * G2(x)

        if c_i == np.inf:
            c_i = 0

        if c_i > c:
            c = c_i
    iteration += 1
    if iteration % 10000 == 0:
        print(c)
    return c


c = calculate_c()

print('Final Coeff')
print(c)
