# Safety Statement
Our released code could produce models that produce problematic outputs. 
In releasing our model and accompanying training code, we encourage responsible and ethical usage scenarios. To ensure the model's safe deployment, we require users adhere to ethical principles and legal frameworks when interacting with the models. 


# Installation
Install necessary following [https://github.com/huggingface/alignment-handbook] and activate your environment. 

# Alignment Experiment 
This experiment uses 4 A100 GPUs

```
# SFT
ACCELERATE_LOG_LEVEL=info \
accelerate launch --config_file recipes/accelerate_configs/deepspeed_zero3_slurm.yaml \
--num_processes=4 \
scripts/run_sft.py recipes/zephyr-7b-beta/sft/config_full_slurm.yaml \
--gradient_accumulation_steps=2 \
--output_dir=/path/to/your/sft_ckpt_dir \
--learning_rate=5e-7 \
--other_data_config=recipes/zephyr-7b-beta/data/mix_pku_sft.yaml \
--use_selective=True

# BFPO
ACCELERATE_LOG_LEVEL=info \
accelerate launch --config_file recipes/accelerate_configs/deepspeed_zero3_slurm.yaml \
--num_processes=4 \
scripts/run_bfpo.py recipes/zephyr-7b-beta/safe-ipo/config_full_slurm.yaml \
--per_device_train_batch_size=2 \
--gradient_accumulation_steps=4 \
--output_dir=/path/to/your/rlhf_ckpt_dir \
--model_name_or_path=/path/to/your/sft_ckpt_dir \
--other_data_config=recipes/zephyr-7b-beta/data/balance_safety_dpo.yaml \
--use_selective=True \
--loss_type=bfpo-shift \
--remove_unused_columns=False \
--eval_steps=500 \
--save_steps=500 \
--save_total_limit=20
```


# Red Teaming Experiment

```
ACCELERATE_LOG_LEVEL=info \
accelerate launch --config_file recipes/accelerate_configs/deepspeed_zero3_slurm.yaml \
--num_processes=4 \
scripts/run_safe_ipo.py recipes/zephyr-7b-beta/bfpo/config_full_slurm.yaml \
--per_device_train_batch_size=2 \
--gradient_accumulation_steps=4 \
--output_dir=/path/to/your/ckpt_dir \
--model_name_or_path=HuggingFaceH4/zephyr-7b-beta \
--other_data_config=recipes/zephyr-7b-beta/data/redteaming.yaml \
--use_selective=True \
--loss_type=bfpo \
--save_total_limit=10

```