
import argparse
import yaml
import json




def read_config(config_path):
    with open(config_path, 'r') as file:
        config = yaml.safe_load(file)
        return config


def load_json(file_path):
    with open(file_path, 'r', encoding='utf-8') as file:
        data = json.load(file)
        return data


def load_jsonl(file_path):
    data = []
    with open(file_path, 'r') as file:
        for line in file:
            data.append(json.loads(line))
    return data


def main():
    # Create the parser
    parser = argparse.ArgumentParser(description='Example argparse program.')

    parser.add_argument('--in_path', default='zephyr-7b-beta_red_teaming_generation_safe_help.json', help='Input file path')
    parser.add_argument('--out_path', default='zephyr-7b-beta_beaver_redteaming.json', help='Output file path')

    # Parse the arguments
    args = parser.parse_args()

    outputs = []

    original_set = load_json(args.in_path) if args.in_path.endswith('json') else load_jsonl(args.in_path)

    for item in original_set:
        if not (item['is_modelout1_safe'] and item['is_modelout2_safe']):
            outputs.append(item)
            json.dump(outputs, open(args.out_path, 'w'), ensure_ascii=False, indent=2)


if __name__ == "__main__":
    main()
