import numpy as np
import pandas as pd

def array_to_dataframe(array, array_name, dim_name_level):
    # Convert a numpy array to a panda data frame
    #    array: n-dim np.array
    #    array_name: the name for the values in the array
    #    dim_name_level: n-key dict that specifies the levels (as a list) for each dim
    # For example,
    # array = np.array([[1, 2, 3], 
    #                   [4, 5, 6]])
    # array_name = 'value'
    # dim_name_level = {'sex':['male', 'female'], 
    #                   'class':['a', 'b', 'c']}
    # 
    # df = array_to_dataframe(array, array_name, dim_name_level)
    # df = 'value' | 'sex' | 'class'
    #          1     'male'    'a'
    #          2     'male'    'b'
    #          3     'male'    'c'
    #          4     'female'  'a'
    #          5     'female'  'b'
    #          6     'female'  'c'
    
    df_dict = {array_name:array.flatten()}
    for dim, (name, level) in enumerate(dim_name_level.items()):
        level_dim_expanded = np.expand_dims(level, axis=tuple(range(1, array.ndim-dim)))
        level_broadcasted = np.broadcast_to(level_dim_expanded, shape=array.shape)
        df_dict[name] = level_broadcasted.flatten()
    df = pd.DataFrame(df_dict)
    return df

