import os
import pickle
from typing import Any


def create_dirs_if_not_exist(path: str) -> None:
    if not os.path.exists(path):
        os.makedirs(path)


def save_in_pickle(path: str, file_name: str, data: Any) -> None:
    create_dirs_if_not_exist(path)
    with open(f'{path}/{file_name}.pkl', "wb") as f:
        pickle.dump(data, f, pickle.HIGHEST_PROTOCOL)
