import torch
import torch.nn as nn


class Discriminator(nn.Module):

    def __init__(
        self, input_size: int, output_size: int, hidden_size: int, num_layers: int, dropout: float = .0
    ) -> None:
        super(Discriminator, self).__init__()
        self.lstm = nn.LSTM(input_size, hidden_size, num_layers, dropout=dropout, batch_first=True)
        self.fc = nn.Linear(hidden_size, output_size)
        self.sigmoid = nn.Sigmoid()

    def forward(self, x: torch.Tensor) -> torch.Tensor:
        out, _ = self.lstm(x)
        out = self.fc(out[:, -1])
        out = self.sigmoid(out)
        return out.squeeze()
