import torch
import torch.nn as nn


class Predictor(nn.Module):

    def __init__(self, n_features: int, num_layers: int, hidden_size: int, cutoff: float):
        super().__init__()
        self.lstm = nn.LSTM(n_features, hidden_size, num_layers, batch_first=True)
        self.fc = nn.Linear(hidden_size, n_features * cutoff)

    def forward(self, x: torch.Tensor) -> torch.Tensor:
        out, _ = self.lstm(x)
        return self.fc(out[:, -1])
