#!/usr/bin/env bash

# zero shot clip
python evaluate.py --config configs/pretrained_clip.jsonc \
                   --device 0 \
                   --batch_size 128 &

# zero shot clip with averaging
python evaluate.py --config configs/pretrained_clip.jsonc \
                   --device 0 --add_comments always --num_comms 5 --num_imlabels 0 \
                   --batch_size 128 --comment_fusion averaging &

# finetuned clip with averaging, eval on title
python evaluate.py --config configs/pretrained_clip.jsonc \
                --add_comments train_only \
                --device 0 \
                --batch_size 128 --comment_fusion None \
                --resume saved/models/pretrained_clip_averaging_comments/005_May23_01:54/checkpoint-epoch10.pth &

# finetuned clip with averaging, eval with averaging
python evaluate.py --config configs/pretrained_clip.jsonc \
                --add_comments always \
                --num_comms 5 --num_imlabels 0 --device 0 \
                --batch_size 128 --comment_fusion averaging \
                --resume saved/models/pretrained_clip_averaging_comments/005_May23_01:54/checkpoint-epoch10.pth &

# finetuned clip with random swap, eval with title
python evaluate.py --config configs/pretrained_clip.jsonc \
                --add_comments train_only \
                --device 0 \
                --batch_size 128 --comment_fusion None \
                --resume saved/models/pretrained_clip_random_swap_comments/006_May23_05:34/checkpoint-epoch10.pth &

# finetuned clip with random swap, eval with averaging
python evaluate.py --config configs/pretrained_clip.jsonc \
                --add_comments always \
                --num_comms 1 --num_imlabels 0 --device 0 \
                --batch_size 128 --comment_fusion averaging \
                --resume saved/models/pretrained_clip_random_swap_comments/006_May23_05:34/checkpoint-epoch10.pth &
