#!/usr/bin/env bash

set -eo pipefail

savedir="experiments/ft_from_frozen_finaltf_2"
device=2
num_comms=3
num_imlabels=3

frozen_epochs=5
ft_epochs=8 # 5 + 3

for act in none squash squash1p2 squash1p5 squash1p8 bn; do

    pretrain_name="pretrained_clip_comments_attn_frozen_nc${num_comms}_nl${num_imlabels}_$act"
    finetune_name="pretrained_clip_comments_attn_visualonly_nc${num_comms}_nl${num_imlabels}_$act"

    if [[ -f "$savedir/${pretrain_name}.done" ]]; then
        echo "${pretrain_name} already trained"
    else
        # Train the network with all except finaltf frozen
        python train.py -c configs/pretrained_clip_comments_attn_frozen.jsonc \
            --num_comms $num_comms --num_imlabels $num_imlabels -d $device --residual_activation $act \
            --exp_name $pretrain_name --epochs $frozen_epochs --save_dir $savedir \
            --cached_vision_features data_symlink/clip_vit_embeddings.pth

        # Indicate it is done
        touch $savedir/${pretrain_name}.done
    fi

    chk=$(find $savedir/models/$pretrain_name -name checkpoint-epoch${frozen_epochs}.pth -exec ls -t {} + | head -n1)

    if [[ -f "$savedir/${finetune_name}.done" ]]; then
        echo "${finetune_name} already trained"
    else
        # Finetune the visual branch
        echo "Training with visual unfrozen based on $chk"
        python train.py -c configs/pretrained_clip_comments_attention.jsonc \
            -r "$chk" \
            --num_comms $num_comms --num_imlabels $num_imlabels -d $device --residual_activation $act \
            --exp_name $finetune_name --epochs $ft_epochs --freeze "text,finaltf" \
            --save_dir $savedir

        # Indicate it is done
        touch $savedir/${finetune_name}.done
    fi

done

python train.py -c configs/pretrained_clip.jsonc \
    -d $device --residual_activation $act \
    --exp_name "pretrained_clip_baseline" --epochs $ft_epochs \
    --save_dir $savedir

python train.py -c configs/pretrained_clip.jsonc -d $device \
    --exp_name "pretrained_clip_baseline_visualonly" --epochs $ft_epochs \
    --freeze "text" --save_dir $savedir
