#!/usr/bin/env bash

# finetune clip + avg title&comments
python train.py --config configs/pretrained_clip.jsonc \
                --add_comments always \
                --exp_name pretrained_clip_averaging_comments \
                --num_comms 5 --num_imlabels 0 --device 2  --epochs 11 \
                --batch_size 50 --comment_fusion averaging &

# finetune clip + random title/comment
python train.py --config configs/pretrained_clip.jsonc \
                --add_comments train_only \
                --exp_name pretrained_clip_random_swap_comments \
                --num_comms 1 --num_imlabels 0 --device 0  --epochs 11 \
                --batch_size 50 --comment_fusion random_swap \ &

# finetune clip from frozen clip + adapted title with comments
python train.py --config configs/pretrained_clip_comments_attention.jsonc \
                --exp_name pretrained_clip_adapting_comments_finaltf \
                --num_comms 5 --num_imlabels 0 --device 3  --epochs 22 \
                --batch_size 50 --resume saved/models/frozen_pretrained_clip_fix_nowikidesc_comments_text/001_May20_16:44/checkpoint-epoch10.pth
