#!/usr/bin/env bash

set -eo pipefail

savedir="experiments/msrvtt_ft_6"
device=0
#visual_device="cuda:1"
act=none

frozen_epochs=5
ft_epochs=11 # 6 + 5

BASELINE="/home/ubuntu/REDACTED_timesformer/experiments/timesformer_1/models/pretrained_clip_timesformer_baseline_freezenone/001_May23_19:34/checkpoint-epoch1.pth"
ADAPTED_IMG="/home/ubuntu/REDACTED_timesformer/experiments/timesformer_imbranch_1/models/pretrained_clip_imbranch_timesformer_comments_attn_freezefinaltf_nc5_nl0_none/001_May24_10:08/checkpoint-epoch6.pth"

#for fclr in 0.000005 0.0001 0.00001; do
    #for lr in 0.000005 0.0000005; do

for fclr in 0.000005 0.00001 0.00005; do
    for lr in 0.000005; do
        timelr=$lr
        for to_freeze in "none"; do
            finetune_name="msrvtt_skip_adamw_b128_wd.01_lr${lr}_fclr${fclr}_timelr${timelr}_comments_attn_freeze${to_freeze}_$act"
            if [[ -f "$savedir/${finetune_name}.done" ]]; then
                echo "${finetune_name} already trained"
            else
                # Finetune with timesformer on videos
                python train.py -c configs/msrvtt_ft.jsonc \
                    -r "$ADAPTED_IMG" \
                    -d $device \
                    --residual_activation $act \
                    --epochs $ft_epochs \
                    --freeze "$to_freeze" \
                    --save_dir $savedir \
                    --exp_name $finetune_name \
                    --bs 128 \
                    --lr $lr \
                    --fc_lr $fclr \
                    --time_lr $timelr

                touch $savedir/${finetune_name}.done
            fi

            for testepoch in 7 9 11; do

                ftchk=$(find $savedir/models/$finetune_name -name checkpoint-epoch${testepoch}.pth -exec ls -t {} + | head -n1)

                # MSRVTT eval
                for split in jsfusion; do
                    csvfile="${ftchk}.msrvtt_${split}.csv"
                    if [[ ! -f $csvfile ]]; then
                        echo "Evaluating $ftchk"
                        python retrieval_evaluation.py --dataset MSRVTT_videos \
                            --checkpoint "$ftchk" \
                            --model_type clip_timesformer \
                            --device "cuda:$device" \
                            --split $split \
                            --branch_to_adapt skip \
                            --out_csv "$csvfile"
                    fi
                done
            done
        done
    done
done


KINETICS_IMG="/home/ubuntu/REDACTED_kinetics/experiments/timesformer_imbranch_kinetics_1/models/pretrained_clip_imbranch_timesformer_comments_kinetics_attn_freezenone_nc10_nl0_none/001_May25_21:27/checkpoint-epoch6.pth"

for fclr in 0.000005; do
    for lr in 0.000005; do
        timelr=$lr
        for to_freeze in "none"; do
            finetune_name="msrvtt_kinetics_skip_adamw_b128_wd.01_lr${lr}_fclr${fclr}_timelr${timelr}_comments_attn_freeze${to_freeze}_$act"
            if [[ -f "$savedir/${finetune_name}.done" ]]; then
                echo "${finetune_name} already trained"
            else
                # Finetune with timesformer on videos
                python train.py -c configs/msrvtt_ft.jsonc \
                    -r "$KINETICS_IMG" \
                    -d $device \
                    --residual_activation $act \
                    --epochs $ft_epochs \
                    --freeze "$to_freeze" \
                    --save_dir $savedir \
                    --exp_name $finetune_name \
                    --bs 128 \
                    --lr $lr \
                    --fc_lr $fclr \
                    --time_lr $timelr

                touch $savedir/${finetune_name}.done
            fi

            for testepoch in 7 9 11; do

                ftchk=$(find $savedir/models/$finetune_name -name checkpoint-epoch${testepoch}.pth -exec ls -t {} + | head -n1)

                # MSRVTT eval
                for split in jsfusion; do
                    csvfile="${ftchk}.msrvtt_${split}.csv"
                    if [[ ! -f $csvfile ]]; then
                        echo "Evaluating $ftchk"
                        python retrieval_evaluation.py --dataset MSRVTT_videos \
                            --checkpoint "$ftchk" \
                            --model_type clip_timesformer \
                            --device "cuda:$device" \
                            --split $split \
                            --branch_to_adapt skip \
                            --out_csv "$csvfile"
                    fi
                done
            done
        done
    done
done
