#!/usr/bin/env bash
exp_root=saved/models/frozen_pretrained_clip_fix_nowikidesc
date=001_May20_16:44
epoch_num=10
bs=80

for text in imlabels comments; do

        # evaluate using imlabels
        python evaluate.py \
            --config ${exp_root}_${text}_text/${date}/config.json \
            --resume ${exp_root}_${text}_text/${date}/checkpoint-epoch${epoch_num}.pth \
            --device 0 --branch_to_adapt_val text --num_comms 0 --num_imlabels 5 --batch_size $bs &
        # evaluate using comments
        python evaluate.py \
            --config ${exp_root}_${text}_text/${date}/config.json \
            --resume ${exp_root}_${text}_text/${date}/checkpoint-epoch${epoch_num}.pth \
            --device 3 --branch_to_adapt_val text --num_comms 5 --num_imlabels 0 --batch_size $bs &
        # evaluate using random words
        python evaluate.py \
            --config ${exp_root}_${text}_text/${date}/config.json \
            --resume ${exp_root}_${text}_text/${date}/checkpoint-epoch${epoch_num}.pth \
            --device 3 --branch_to_adapt_val text --random_words true --batch_size $bs &

done