import pickle
from PIL import Image


class imagenet:
    def __init__(self, data, transform=None):
        self.data = data
        self.imgs = data['imgs']
        self.labels = data['labels']
        self.transform = transform

    def __len__(self):
        return len(self.imgs)
    
    def __getitem__(self, idx):
        img = Image.open(self.imgs[idx]).convert('RGB')
        label = self.labels[idx] 
        if self.transform is not None:
            img = self.transform(img)
        return img, label


def load_data(pickle_filename):
    with open(pickle_filename, "rb") as input_file:
        data = pickle.load(input_file)
    out = dict()
    out['imgs'] = data['train']['imgs']+data['val']['imgs']+data['test']['imgs']
    out['labels'] = data['train']['labels']+data['val']['labels']+data['test']['labels']
    return out