import torch.nn as nn
import torchvision
from .resnet import *
from .resnet_imagenet import *


class Online(nn.Module):
    def __init__(self, args, data='non_imagenet'):
        super(Online, self).__init__()
        self.args = args
        if data == 'imagenet':
            self.encoder = self.get_imagenet_resnet(args.resnet)
        else:
            self.encoder = self.get_resnet(args.resnet)

        self.n_features = self.encoder.feat_dim
        self.projector = nn.Sequential(nn.Linear(self.n_features, self.n_features),
                                       nn.BatchNorm1d(self.n_features),
                                       nn.ReLU(inplace=True),
                                       nn.Linear(self.n_features, args.projection_dim))
        self.predictor = nn.Sequential(nn.Linear(args.projection_dim, args.projection_dim),
                                       nn.BatchNorm1d(args.projection_dim),
                                       nn.ReLU(inplace=True),
                                       nn.Linear(args.projection_dim, args.projection_dim))

    def get_resnet(self, name):
        resnets = {
            "resnet18": resnet18(pool_len=4, data=self.args.dataset),
            "resnet34": resnet34(pool_len=4, data=self.args.dataset),
            "resnet50": resnet50(pool_len=4, data=self.args.dataset),
            "resnet101": resnet101(pool_len=4, data=self.args.dataset),
            "resnet152": resnet152(pool_len=4, data=self.args.dataset)}
        if name not in resnets.keys():
            raise KeyError(f"{name} is not a valid ResNet version")
        return resnets[name]
     
    def get_imagenet_resnet(self, name):
        resnets = {
            "resnet18": resnet18_imagenet(),
            "resnet34": resnet34_imagenet(),
            "resnet50": resnet50_imagenet(),
            "resnet101": resnet101_imagenet(),
            "resnet152": resnet152_imagenet()}
        if name not in resnets.keys():
            raise KeyError(f"{name} is not a valid ResNet version")
        return resnets[name]

    def forward(self, x):
        h = self.encoder(x)
        z = self.projector(h)
        pred = self.predictor(z)
        return h, z, pred


class Target(nn.Module):
    def __init__(self, args, data='non_imagenet'):
        super(Target, self).__init__()
        self.args = args
        if data == 'imagenet':
            self.encoder = self.get_imagenet_resnet(args.resnet)
        else:
            self.encoder = self.get_resnet(args.resnet)

        self.n_features = self.encoder.feat_dim
        self.projector = nn.Sequential(nn.Linear(self.n_features, self.n_features),
                                       nn.BatchNorm1d(self.n_features),
                                       nn.ReLU(inplace=True),
                                       nn.Linear(self.n_features, args.projection_dim))

    def get_resnet(self, name):
        resnets = {
            "resnet18": resnet18(pool_len=4, data=self.args.dataset),
            "resnet34": resnet34(pool_len=4, data=self.args.dataset),
            "resnet50": resnet50(pool_len=4, data=self.args.dataset),
            "resnet101": resnet101(pool_len=4, data=self.args.dataset),
            "resnet152": resnet152(pool_len=4, data=self.args.dataset)}
        if name not in resnets.keys():
            raise KeyError(f"{name} is not a valid ResNet version")
        return resnets[name]

    def get_imagenet_resnet(self, name):
        resnets = {
            "resnet18": resnet18_imagenet(),
            "resnet34": resnet34_imagenet(),
            "resnet50": resnet50_imagenet(),
            "resnet101": resnet101_imagenet(),
            "resnet152": resnet152_imagenet()}
        if name not in resnets.keys():
            raise KeyError(f"{name} is not a valid ResNet version")
        return resnets[name]

    def forward(self, x):
        h = self.encoder(x)
        z = self.projector(h)
        return h, z