import torch

def mask_correlated_samples(batch_size):
    mask = torch.ones((batch_size*2, batch_size*2)).bool()
    mask = mask.fill_diagonal_(0)
    for i in range(batch_size):
        mask[i, batch_size+i] = 0
        mask[batch_size+i, i] = 0
    return mask
