
## Instance segmentation on Cityscapes

The `train_net.py` script reproduces the instance segmentation experiments on Cityscapes.

### Instruction

1. Install [detectron2](https://github.com/facebookresearch/detectron2/blob/master/INSTALL.md).

2. Convert a pre-trained model to detectron2's format:
   ```
   python convert.py pretrain/Pretrain_Name.pt pretrain/Pretrain_Name.pkl
   ```

3. Put Cityscapes dataset under "/datasets" directory,
   following the [directory structure](https://github.com/facebookresearch/detectron2/tree/master/datasets)
	 requried by detectron2.

4. Run training:
   ```
   python train_net.py --config-file configs/cityscapes_instance_R50_FPN.yaml --num-gpus 4 MODEL.WEIGHTS pretrain/Pretrain_Name.pkl OUTPUT_DIR output/Pretrain_Name
   ```