#!/Users/wangmengchang/opt/anaconda3/bin/python3
import os
import sys
import datetime
import random

def parse_line(lnstr, reverse=False):
	if lnstr.startswith('|'):
		parts = lnstr.split(sep='|')
		if len(parts)>2:
			#print('[0] = ',parts[0],'  [1] = ',parts[1],'  [2] = ',parts[2])
			try:
				i = int(parts[1])
				v = float(parts[2])
				if reverse:
					v = -v
				print(i,': ', v)
				return i,v
			except Exception:
				return None,None
	return None,None


def process_file(fn, iters = 10000, prob='Robot-Push(D14)', reverse=False):
	res=[]
	with open(fn,'rt') as txtf:
		for lnstr in txtf.readlines():
			lnstr = lnstr.replace(' ', '')
			i,v = parse_line(lnstr.strip(),reverse=reverse)
			if i is not None and v is not None:
				res.append((i,v))
	inserted =[]
	L = len(res)
	
	last_value = res[0][1]

	for i in range(iters):
		idx = i+1
		y = None
		for j,v in res:
			if j <= idx:
				y = v
		if y is None:
			y = last_value
		last_value = y
		inserted.append(y)

	logfnparts = fn.split(sep='.')
	
	xfn = 'progress_CobBO(new)_%s_%s_%d.csv'%(prob, logfnparts[0],random.randint(100,500))
	with open(xfn,'wt') as of:
		for y in inserted:
			of.write('%f\n'%y)



if __name__ == '__main__':
	fn = str(sys.argv[1])
	prob='Robot-Push(D14)'
	pr = str(sys.argv[2])
	reverse = (str(sys.argv[3]) == 'reverse')
	if pr == 'rover':
		prob='Rover(D60)'
	elif pr == 'push':
		prob='Robot-Push(D14)'
	elif pr == 'ackley100':
		prob = 'Ackley(D100)'
	elif pr == 'levy100':
		prob = 'Levy(D100)' 

	process_file(fn, prob=prob, reverse=reverse)

