#!/bin/bash

ProjRoot="<absolute-path-to-this-repo>"
ScriptRoot="<absolute-path-to-this-repo>"
RM="Skywork/Skywork-Reward-Gemma-2-27B-v0.2"
UtilRoot="${ProjRoot}/utils"
GeneratedDataPath="${ScriptRoot}/generated_data"
AnnotationProgram="${ProjRoot}/run_annotation.py"
PythonPath="/data/miniconda3/envs/softdpo124/bin/python"
AcceleratePath="<path-to-accelerate-binary>"
AccelerateConfig="${ProjRoot}/configs/zero2.yaml"

TargetDs=${GeneratedDataPath}/<ds-name>

WorldSize=8

CUDA_VISIBLE_DEVICES=0 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 0 --rm_path=${RM} &
CUDA_VISIBLE_DEVICES=1 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 1 --rm_path=${RM} &
CUDA_VISIBLE_DEVICES=2 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 2 --rm_path=${RM} &
CUDA_VISIBLE_DEVICES=3 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 3 --rm_path=${RM} &
CUDA_VISIBLE_DEVICES=4 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 4 --rm_path=${RM} &
CUDA_VISIBLE_DEVICES=5 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 5 --rm_path=${RM} &
CUDA_VISIBLE_DEVICES=6 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 6 --rm_path=${RM} &
CUDA_VISIBLE_DEVICES=7 ${PythonPath} ${AnnotationProgram} annotate \
    --ds_path=${TargetDs} \
    --output_dir ${GeneratedDataPath} \
    --world_size ${WorldSize} --local_rank 7 --rm_path=${RM} &
wait

${PythonPath} ${AnnotationProgram} merge ${GeneratedDataPath} "${TargetDs}_w_reward"