#!/bin/bash

ProjRoot="<absolute-path-to-this-repo>"
ScriptRoot="<absolute-path-to-this-repo>"
RM="Skywork/Skywork-Reward-Gemma-2-27B-v0.2"
UtilRoot="${ProjRoot}/utils"
GeneratedDataPath="${ScriptRoot}/generated_data"
AnnotationProgram="${ProjRoot}/run_annotation.py"
PythonPath="/data/miniconda3/envs/softdpo124/bin/python"
AcceleratePath="<path-to-accelerate-binary>"
AccelerateConfig="${ProjRoot}/configs/zero2.yaml"

TargetDs=${GeneratedDataPath}/<ds-name>

WorldSize=8

TargetLM=${GENLM}
OutputName=${OUTN}

CUDA_VISIBLE_DEVICES=0 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 0 &
CUDA_VISIBLE_DEVICES=1 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 1 &
CUDA_VISIBLE_DEVICES=2 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 2 &
CUDA_VISIBLE_DEVICES=3 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 3 &
CUDA_VISIBLE_DEVICES=4 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 4 &
CUDA_VISIBLE_DEVICES=5 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 5 &
CUDA_VISIBLE_DEVICES=6 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 6 &
CUDA_VISIBLE_DEVICES=7 ${PythonPath} ${GenerationProgram} generate \
    "raw_data/alpaca_eval" ${TargetLM} \
    --output_dir ${GeneratedDataPath} \
    --output_dataname "${OutputName}" \
    --prompt_column "instruction" --temperature 1.0 --top_p 0.9 --num_beams 3 --n_generation_per_prompt 1 \
    --world_size ${WorldSize} --local_rank 7 &
wait

${PythonPath} ${GenerationProgram} merge ${GeneratedDataPath} "${GeneratedDataPath}/${OutputName}"

${PythonPath} ${GenerationProgram} convert-to-json "${GeneratedDataPath}/${OutputName}" "${GeneratedDataPath}/${OutputName}.json" --format_to_alpaca true