# The hidden label-marginal biases of segmentation losses

## Getting Started

### Install
1. pytorch from [official site](https://pytorch.org/):
```
torch==1.7.0
torchvision==0.8.2
```

2. Other dependencies:
```
pip install -r requirements.txt
```

3. Intall the library:
```
python setup.py develop
```

### Prepare dataset
1. Cityscapes :
To download the dataset, please refer to the [official site](https://www.cityscapes-dataset.com/).

Here is the recommended data structure :
```
├── Data
│   ├── cityscapes
│       ├── gtFine
│       ├── leftImg8bit
│       ├── license.txt
│       └── README
```
By convention, `**labelTrainIds.png` are used for cityscapes training and validation.
We use the [scripts](https://github.com/open-mmlab/mmsegmentation/blob/master/tools/convert_datasets/cityscapes.py) in [mmsegmentation](https://github.com/open-mmlab/mmsegmentation) to generate `**labelTrainIds.png`.

2. Retinal lesions : 
This dataset is freely available but you might submit a request on their [repo](https://github.com/WeiQijie/retinal-lesions).

We provide the experimental data split txt in our repo.
Here is the data structure to reproduce :
```
── data
│   └── retinal-lesions-v20191227
│       ├── classes.txt
│       ├── images_896x896
│       ├── lesion_segs_896x896
│       ├── test.txt
│       ├── train.txt
│       └── val.txt
```

### Testing with trained models
We provide our trained models on Cityscapes and Retinal Lesions for direct testing.
Please download here :
* [Cityscapes model](https://drive.google.com/file/d/1WzYyI2CrwKi11fwm4--FHLqyuNkfge5D/view?usp=sharing)
* [Retinal-lesions model](https://drive.google.com/file/d/1tkCV537Z8J9k6mJbWa2XGMh8ZGUyjhdt/view?usp=sharing)

Test on Cityscapes :
```
python test_cv.py --config-file ./exp/cityscapes_r50fpn_512x1024_ce_l1.yaml \\
    TEST.CHECKPOINT_PATH trained_models/cityscapes_r50fpn_512x1024_ce_l1.pth(or_your_local_path)
```

Test on Retinal Lesions :
```
python test.py --config-file ./exp/retinal-lesions_r50fpn_bce_l1.yaml \\
    TEST.CHECKPOINT_PATH trained_models/retinal-lesions_r50fpn_bce_l1.pth(or_your_local_path)
```


### Training

On Cityscapes:
```
python train_cv.py --config-file ./exp/cityscapes_r50fpn_512x1024_ce_l1.yaml
```

On Retinal Lesions:
```
python train.py --config-file ./exp/retinal-lesions_r50fpn_bce_l1.yaml
```

You might need modify some paths in the config files according to your local path.
For the meaning of each paramter within the config, please refer to `./config/defaults.py`.