import os.path as osp
import os
import numpy as np
import argparse
from utils import mkdir, zipdir
from dataset.cityscapes import CityscapesDataset
import cv2
from tqdm import tqdm


def parse_args():
    parser = argparse.ArgumentParser(description='Get Cityscapes Submit')
    parser.add_argument("--data-path", metavar="FILE DIR",
                        help="path to predicted data")
    parser.add_argument("--out-path", default="",
                        help="path to predicted data")
    args = parser.parse_args()

    return args


def main():
    args = parse_args()
    data_path = args.data_path
    out_path = args.out_path
    mkdir(out_path)
    files = os.listdir(data_path)
    print("Predict data : {} samples found in {}".format(len(files), data_path))
    for fpath in tqdm(files):
        fpath = osp.join(data_path, fpath)
        data = np.load(fpath)
        sample_id = str(data["sample_id"])
        predict = data["predict"]
        pred_label = np.argmax(predict, axis=0)
        out_image = np.zeros_like(pred_label, dtype=np.uint8)
        labels = np.unique(pred_label)
        for l in labels:
            out_image[pred_label == l] = CityscapesDataset.IDS[l]
        # save out image
        out_file = osp.join(out_path, sample_id + "map.png")
        cv2.imwrite(out_file, out_image)
    print("Zipping ... ")
    zipdir(out_path, out_path.rstrip("/") + ".zip")
    print("Mission complete !")

if __name__ == "__main__":
    main()