This repository contains the processing code used in the experiments of the paper "Heteroscedastic Gaussian Processes and
Random Features: Fast Movement Primitives with Guarantees" submitted to CoRL 2023.

The data of the trajectories are taken from [https://codeocean.com/capsule/9688212/tree/v2].

In order to process the trajectories of the three experiments offline, run the script ``process_trajs.py``. In this case, all the human demonstrations are merged and form a unique dataset.

In order to process the trajectories online, run the script ``process_trajs_online.py``. In this case, the posterior distribution of the HGP is subject to low-rank updates as soon as a new trajectory is processed.

The script ``MLHGP_RFFs.py`` contains the implementation of the EM algorithm used for training the RF-HGP and the exact HGP.
The script ``gp_utilities.py`` contains the implementation of the RF-based kernel, as well as the Nyström approximation used in our online processing experiments.
