import torch
import os
import numpy as np
from .libs.clip import FrozenCLIPEmbedder
import argparse
from tqdm import tqdm


def main():
    prompts = [
        '',
    ]

    device = 'cuda'
    clip = FrozenCLIPEmbedder()
    clip.eval()
    clip.to(device)

    save_dir = f'/gpfs/projects/bsc70/bsc193242/Data/coco256_features'
    latent = clip.encode(prompts)
    print(latent.shape)
    c = latent[0].detach().cpu().numpy()
    np.save(os.path.join(save_dir, f'empty_context.npy'), c)


if __name__ == '__main__':
    main()
