#!/bin/bash
#SBATCH -J preprocessing_cc3m
#SBATCH --exclusive
#SBATCH --account=bsc70
#SBATCH --qos=acc_bsccs
#SBATCH --output=slurm_output/out.txt
#SBATCH --error=slurm_output/err.txt
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --time=48:00:00
#SBATCH --gres=gpu:1

echo "START TIME: $(date)"

# export SINGULARITY_TMPDIR=/dev/shm/
module purge
module load singularity

# Set environment variables for PyTorch distributed training
export MASTER_ADDR=$(hostname)
export MASTER_PORT=29500  # Ensure this port is free
export WORLD_SIZE=$SLURM_NTASKS  # Total number of processes (4 GPUs)
export NCCL_DEBUG=INFO  # Enable debugging logs for NCCL
export NCCL_P2P_DISABLE=1  # Prevents certain deadlocks
export NCCL_IB_DISABLE=1
#export CUDA_VISIBLE_DEVICES=0
export CUDA_LAUNCH_BLOCKING=1


# Use `torchrun` instead of direct python execution
singularity exec --nv /gpfs/projects/bsc70/heka/singularity/synthetic-data/gm_14_08.sif \
    accelerate launch -m t2i.preprocessing.extract_mscoco_feature --split="train" --dataset="mscoco"

#singularity exec --nv /gpfs/projects/bsc70/heka/singularity/synthetic-data/gm_14_08.sif \
#    accelerate launch -m t2i.preprocessing.extract_empty_feature 

echo "END TIME: $(date)"