import os
import sys
sys.path.insert(0, './')
import json
import time
import pickle
import numpy as np

import torch
import torch.nn as nn
import torch.nn.functional as F

class MIA(object):

    def __init__(self, name, threshold, metric, mia_mode):
        '''
        >>> name: name of this method
        >>> threshold: float, the threshold to identify member or non-member
        >>> metric: metric function, you can obtain the metric number by metric(model, data)
        '''

        self.name = name
        self.metric = metric
        self.threshold = threshold
        self.mia_mode = mia_mode

    def fit(self, model, train_data_generator, shadow_data_generator, **kwargs):
        '''
        >>> model: model under MIA
        >>> train_data_generator: a generator to generate training data by train_data_generator.next()
        >>> shadow_data_generator: a generator to generate shadow data by shadow_data_generator.next()
        '''
        raise NotImplementedError('Methods of parent classes are not implemented.')

    def infer(self, model, data, label):
        '''
        >>> model: model under MIA
        >>> data: batch of data, you can obtain the logit by model(data)
        '''
        raise NotImplementedError('Methods of parent classes are not implemented.')
