#!/bin/bash

# load epoch number
epochs=(200 110 10)
model_suffixs=('.ckpt' '_110.ckpt' '_10.ckpt' )

gpus=(0)

arch="resnet"
dataset='cifar100_new_split'

attack_method=('lira' 'rmia' 'entropy' 'm_entropy' 'confidence' 'quantile' 'merlin' 'mlleak1' 'mlleak3' 'shadowmia' 'blind-one' 'blind-diffw' 'blind-diffsingle' 'blind-diffbi')
eval_method=('lira' 'rmia' 'entropy' 'm_entropy' 'confidence' 'quantile' 'merlin')

attack_method=('rmia' 'quantile' 'merlin' 'shadow')
attack_type="attack"
exp_name="CIFAR100_RN18"
model_path=model/${dataset}/vanilla_resnet50_pretrain/${arch}

for i in "${!epochs[@]}"; do
    epoch=${epochs[$i]}
    
    for j in "${!attack_method[@]}"; do
        method=${attack_method[$j]}
        gpu=${gpus[$((i % ${#gpus[@]}))]}
        model_suffix=${model_suffixs[$i]}
        target_model_path=${model_path}${model_suffix}
        config_path=./config/run/${exp_name}/Attack/${method}.yaml
        out_file=/data/xzhong/mia_bench/result/${exp_name}/${method}_${attack_type}_${epoch}.ckpt
        log_file=/data/xzhong/mia_bench/result/${exp_name}/${method}_${attack_type}_${epoch}.log
        echo "Running load_epoch=$epoch on GPU $gpu"
        echo "./run/mia.py --yaml $config_path --load_epoch $epoch --model2load $target_model_path --out_file $out_file"
        CUDA_VISIBLE_DEVICES=$gpu python ./run/mia.py --yaml $config_path --load_epoch $epoch --model2load $target_model_path --out_file $out_file
        if [ $? -ne 0 ]; then
        echo "Error: mia.py failed with epoch=$epoch, method=$method. Exiting."
        exit 1
        fi
    done
done


# Eval Method
attack_type="eval"
for i in "${!epochs[@]}"; do
    epoch=${epochs[$i]}
    
    for j in "${!eval_method[@]}"; do
        method=${eval_method[$j]}
        gpu=${gpus[$((i % ${#gpus[@]}))]}
        model_suffix=${model_suffixs[$i]}
        target_model_path=${model_path}${model_suffix}
        config_path=./config/run/${exp_name}/Eval/${method}.yaml
        out_file=/data/xzhong/mia_bench/result/${exp_name}/${method}_${attack_type}_${epoch}.ckpt
        log_file=/data/xzhong/mia_bench/result/${exp_name}/${method}_${attack_type}_${epoch}.log
        echo "Running load_epoch=$epoch on GPU $gpu"
        echo "./run/mia.py --yaml $config_path --load_epoch $epoch --model2load $target_model_path --out_file $out_file"
        CUDA_VISIBLE_DEVICES=$gpu python ./run/mia.py --yaml $config_path --load_epoch $epoch --model2load $target_model_path --out_file $out_file 
        if [ $? -ne 0 ]; then
        echo "Error: mia.py failed with epoch=$epoch, method=$method. Exiting."
        exit 1
        fi
    done
done
