#! /bin/bash


gpu=0
chunk_lst=(0 1 2 3 4)
model_lst=("resnet")

for model in "${model_lst[@]}"; do
  echo Model $model
  python -u train/vanilla.py --yaml config/train/cifar100_resnet.yaml --arch $model --dataset cifar100 --out_folder model/cifar100_new_split/vanilla_${model} --is_split --gpu $gpu
  for chunk in "${chunk_lst[@]}"; do
      python -u train/vanilla.py --yaml config/train/cifar100_resnet.yaml --arch $model --dataset cifar100 --shadow_seed $chunk --out_folder model/cifar100_new_split/shadow_${model}/$chunk --is_split --is_shadow --gpu $gpu
  done
done
