import os
import sys

from MIA.ShadowMIA import ShadowMIA
from MIA.MLLeaks import MLLeaks
from MIA.BlindMI import BlindMI
from MIA.Merlin import Merlin
from MIA.MetricMIA import MetricMIA
from MIA.LiRA import LiRA
from MIA.RMIA import RMIA
from MIA.QuantileMIA_wrap import QMIAModel

sys.path.insert(0, './')
import numpy as np

from MIA.Naive import NaiveMIA

h_message = '''
'''

def parse_mia(method, **kwargs):

    if method.lower() in ['h', 'help']:
        print(h_message)
        exit(0)
    elif method.lower() in ['naive',]:
        return NaiveMIA(**kwargs)
    elif method.lower() in ['shadowmia',]:
        return ShadowMIA(**kwargs)
    elif method.lower() in ['mlleaks',]:
        return MLLeaks(**kwargs)
    elif method.lower() in ['blindmi',]:
        return BlindMI(**kwargs)
    elif method.lower() in ['merlin', ]:
        return Merlin(**kwargs)
    elif method.lower() in ['metricmia', ]:
        return MetricMIA(**kwargs)
    elif method.lower() in ['quantilemia', 'quantilemia_v2']:
        return QMIAModel(**kwargs)
    elif method.lower() in ['lira', ]:
        return LiRA(**kwargs)
    elif method.lower() in ['rmia', ]:
        return RMIA(**kwargs)
    else:
        raise NotImplementedError('MIA named %s is not supported' % method)

