import os
import sys
sys.path.insert(0, './')
import numpy as np

h_message = '''
>>> You can use "min" or "max" to control the minimum and maximum values.
>>> constant
y = c
>>> linear
y = start_v + x * slope
>>> exp / exponential
y = start_v * power ** (x / interval)
>>> jump
y = start_v * power ** (max(idx - min_jump_pt + jump_freq, 0) // jump_freq)
>>> cos, cosine
y = start_v * (alpha + (1 - alpha) / 2 * (1 + cos(pi * x / circle)))
'''

def parse_seq(*args, **kwargs):
    '''
    >>> return a float to float mapping
    '''

    name = kwargs['name']
    max_v = kwargs['max'] if 'max' in kwargs else np.inf
    min_v = kwargs['min'] if 'min' in kwargs else -np.inf

    if name.lower() in ['h', 'help']:
        print(h_message)
        exit(0)
    elif name.lower() in ['constant', 'const']:
        start_v = float(kwargs['start_v'])
        base_func = lambda x: np.clip(start_v, a_min = min_v, a_max = max_v)
    elif name.lower() in ['linear',]:
        start_v = float(kwargs['start_v'])
        slope = float(kwargs['slope'])
        base_func = lambda x: np.clip(start_v + x * slope, a_min = min_v, a_max = max_v)
    elif name.lower() in ['exp', 'exponential',]:
        start_v = float(kwargs['start_v'])
        power = float(kwargs['power'])
        interval = int(kwargs['interval']) if 'interval' in kwargs else 1
        base_func = lambda x: np.clip(start_v * power ** (x / float(interval)), a_min = min_v, a_max = max_v)
    elif name.lower() in ['jump',]:
        start_v = float(kwargs['start_v'])
        power = float(kwargs['power'])
        min_jump_pt = int(kwargs['min_jump_pt'])
        jump_freq = int(kwargs['jump_freq'])
        base_func = lambda x: np.clip(start_v * power ** (max(x - min_jump_pt + jump_freq, 0) // jump_freq), a_min = min_v, a_max = max_v)
    elif name.lower() in ['steplr', 'step_lr']:
        start_v = float(kwargs['start_v'])
        power = float(kwargs['power'])
        interval = int(kwargs['interval']) if 'interval' in kwargs else 1
        base_func = lambda x: np.clip(start_v * power ** (x // interval), a_min = min_v, a_max = max_v)
    elif name.lower() in ['cos', 'cosine']:
        start_v = float(kwargs['start_v'])
        alpha = float(kwargs['alpha']) if 'alpha' in kwargs else 0.0
        circle = float(kwargs['circle'])
        base_func = lambda x: np.clip(start_v * (alpha + (1 - alpha) / 2 * (1 + np.cos(np.pi * x / circle))), a_min = min_v, a_max = max_v)
    else:
        raise NotImplementedError('Sequence %s is not supported' % name)

    return base_func
