import numpy as np
import pandas as pd


def get_dataset(path='./Concrete_Data.csv'):
    """
    Load the Concrete Strength dataset
    And construct the features as in the particles package
    In the experiments, we directly use concrete_from_particles.csv as generated by concrete.py
    """
    df = pd.read_csv(path)
    new_columns = ["C", "BLAST", "FASH", "W", "PLAST", "CA", "FA", "AGE", "CS"]
    df.rename(columns={df.columns[i]: new_columns[i] for i in range(9)}, inplace=True)
    to_logarithm_fields_idx = [0, 3, 5, 6, 7]  # ['C', 'W', 'CA', 'FA', 'AGE']
    for idx in to_logarithm_fields_idx:
        df[df.columns[idx] + '_LG'] = np.log(df[df.columns[idx]])
    for idx in range(df.shape[1]):
        for idx2 in range(idx):
            if idx != 8 and idx2 != 8:
                df[df.columns[idx] + df.columns[idx2]] = df[df.columns[idx]] * df[df.columns[idx2]]
    df['cst'] = 1
    return df
