from addict import Dict
import numpy as np

from webpage.video_app import interact_with_user, run_app
import time, requests
from json import JSONDecodeError

cfg = {}
cfg['env'] = {
  'name': 'quadruped_walk',
  'env_action_space': 'continuous',
  'env_time_limit': -1,
  'params': None}
cfg['seed'] = 1
cfg = Dict(cfg)


import utils

env = utils.make_env(cfg)

videos = []
rewards = []
ITERS = 20

for ix in range(ITERS):
    env.reset()
    done = False
    this_video = []
    this_reward = []
    while not done :
        obs, reward, done, info = env.step(env.action_space.sample())
        this_video.append(obs)
        this_reward.append(reward)
    videos.append(this_video)
    rewards.append(this_reward)


# convert to np
v, r = np.array(videos), np.array(rewards)


vt = v.transpose(0,1,3,4,2)
returns = r.sum(axis=-1)
indices = np.argsort(returns)

QUERIES = 10
# best 3 and worst three
bt = vt[indices[:QUERIES]]
wt = vt[indices[-QUERIES:]]

# center crop
crop = 50
bt = bt[:, :, crop:240-crop, crop:320-crop, :]
wt = wt[:, :, crop:240-crop, crop:320-crop, :]

from skimage.transform import resize
def enlarge_image(image, large_height, large_width):
    batch_size, frames, height, width, channels = image.shape
    enlarged_image = resize(image, (batch_size, frames, large_height, large_width, channels))

    return enlarged_image

bt = (enlarge_image(bt, 240, 320)*255).astype('uint8')
wt = (enlarge_image(wt, 240, 320)*255).astype('uint8')

# invert colors
bit = np.invert(bt)
wit = np.invert(wt)


# create video list
videos_list = []
for ix in range(wt.shape[0]):
    tup = (wit[ix], bit[ix])
    videos_list.append(tup)

def human_in_loop_interaction(videos_list):
    server_process = interact_with_user(videos_list)

    # Wait until the user has provided feedback for all video pairs
    while True:
        try:
            feedback_complete = requests.get("http://127.0.0.1:5000/is_feedback_complete").json()["complete"]
            if feedback_complete:
                break
        except JSONDecodeError:
            pass
        time.sleep(1)

    # Access the user feedback responses
    responses = requests.get("http://127.0.0.1:5000/get_responses").json()
    print("User feedback responses:", responses)

run_app()
human_in_loop_interaction(videos_list)

print("Done")

