import logging
from flask import Flask, render_template, request, jsonify
import numpy as np
import base64
import os

import threading

from moviepy.editor import ImageSequenceClip

# Disable MoviePy logging
logger = logging.getLogger('werkzeug')
logger.setLevel(logging.ERROR)

app = Flask(__name__)
app.config['videos'] = []

videos = []
responses = []


@app.route('/consent_page')
def consent_page():
    return render_template("consent.html")

@app.route("/")
def index():
    return render_template("index.html")


@app.route("/get_videos")
def get_videos():
    global videos
    # Convert videos to base64-encoded data URIs
    video_data_uris = []
    for left_video, right_video in videos:
        left_data_uri = numpy_array_to_data_uri(left_video)
        right_data_uri = numpy_array_to_data_uri(right_video)
        video_data_uris.append({"left": left_data_uri, "right": right_data_uri})
    return jsonify(video_data_uris)


def numpy_array_to_data_uri(numpy_array):
    temp_file = "temp.webm"

    # Convert numpy array to a list of images
    images = [(frame * 255).astype(np.uint8) for frame in numpy_array]

    # Create a video clip from the images
    clip = ImageSequenceClip(images, fps=20)

    # Save the video clip as a WebM file
    clip.write_videofile(temp_file, codec='libvpx', audio=False, logger=None)

    # Encode the video file as a base64 data URI
    with open(temp_file, "rb") as f:
        data_uri = base64.b64encode(f.read()).decode("utf-8")
    os.remove(temp_file)

    return f"data:video/webm;base64,{data_uri}"


@app.route("/submit_response", methods=["POST"])
def submit_response():
    data = request.get_json()
    responses.append({"video_index": data["video_index"], "preference": data["preference"],
                      "selected_option": data["selected_option"]})
    return jsonify(success=True)


@app.route("/user_feedback")
def user_feedback():
    return render_template("feedback.html", responses=responses)


@app.route("/is_feedback_complete")
def is_feedback_complete():
    return jsonify(complete=len(responses) == len(videos))


@app.route("/get_responses")
def get_responses():
    return jsonify(responses)


# @app.route("/shutdown", methods=["POST"])
# def shutdown():
#     def shutdown_server():
#         func = request.environ.get("werkzeug.server.shutdown")
#         if func is None:
#             raise RuntimeError("Not running with the Werkzeug Server")
#         func()
#
#     # Shut down the server after a 1-second delay
#     shutdown_timer = Timer(1, shutdown_server)
#     shutdown_timer.start()
#
#     return jsonify(success=True)

def run_app():
    server_thread = threading.Thread(target=app.run, kwargs={"debug": True, "use_reloader": False})
    server_thread.start()

    return server_thread


def interact_with_user(videos_list):
    global videos
    videos = videos_list

    responses.clear()  # Reset the responses variable
    # Run the Flask server in a separate thread


if __name__ == "__main__":
    app.run(debug=True)
