import argparse
import math
from gp import *

pcts = torch.tensor((.1, .2, .3, .4, .5))
resols = torch.tensor((5, 10, 20, 30))
reps = torch.tensor((0, 1, 2, 3))
clust_sizes = torch.arange(1, 8) * 10
thetas = torch.tensor((1., math.exp(1.), 6.))
pflips = torch.tensor((0.,.25,.5,.75))

def set_args():
    args = torch.zeros((
        pcts.shape[0], resols.shape[0], reps.shape[0], 
        clust_sizes.shape[0], thetas.shape[0],
        pflips.shape[0], 6
    ))
    for i in range(args.shape[0]):
        for j in range(args.shape[1]):
            for k in range(args.shape[2]):
                for l in range(args.shape[3]):
                    for m in range(args.shape[4]):
                        for n in range(args.shape[5]):
                            args[i,j,k,l,m,n,:] = torch.tensor((
                                pcts[i],resols[j],reps[k],clust_sizes[l],
                                thetas[m], pflips[n]
                            ))
    return args.reshape((torch.tensor(args.shape[:-1]).prod(),6))

if __name__ == "__main__":
    args = set_args()
    parser = argparse.ArgumentParser()
    parser.add_argument("--index", type=int)
    indx = parser.parse_args().index-1
    run_simulations(indx, *args[indx,:])
