// modified version of the stan code generated internally by brms 2.22.0
// modified to incorporate proxy information and r-weighting
functions {
}
data {
  int<lower=1> N;  // total number of observations
  array[N] int Y;  // response variable
  array[N] int trials;  // number of trials
  int<lower=1> K;  // number of population-level effects
  matrix[N, K] X;  // population-level design matrix
  int prior_only;  // should the likelihood be ignored?
  real z;
  int use_proxy;
  real<lower=0> proxy_sd;
}
transformed data {
}
parameters {
  vector[K] b;  // regression coefficients
}
transformed parameters {
  real lprior = 0;  // prior contributions to the log posterior
  lprior += normal_lpdf(b | 0, 3);
}
model {
  // likelihood including constants
  if (!prior_only) {
    // initialize linear predictor term
    vector[N] mu = rep_vector(0.0, N);
    mu += X * b;
    real R_denom = binomial_logit_lpmf(Y | trials, b[1]);
    R_denom /= N;
    for (n in 1:N) {
      real R = binomial_logit_lpmf(Y[n] | trials[n], b[1]);
      R -= R_denom;
      R = exp(R);
      R = inv_logit(R);
      target += R * (binomial_logit_lpmf(Y[n] | trials[n], mu[n]));
    }
    if (use_proxy) {
        target += normal_lpdf(z | b[1], proxy_sd);
    }
  }
  // priors including constants
  target += lprior;
}
generated quantities {
}

