// modified version of the stan code generated internally by brms 2.22.0
// modified to incorporate proxy information
functions {
}
data {
  int<lower=1> N;  // total number of observations
  array[N] int Y;  // response variable
  array[N] int trials;  // number of trials
  int<lower=1> K;  // number of population-level effects
  matrix[N, K] X;  // population-level design matrix
  int prior_only;  // should the likelihood be ignored?
  real z;
  int target_task_id;
  int use_proxy;
  real<lower=0> proxy_sd;
}
transformed data {
}
parameters {
  vector[K] b;  // regression coefficients
}
transformed parameters {
  real lprior = 0;  // prior contributions to the log posterior
  lprior += normal_lpdf(b | 0, 3);
}
model {
  // likelihood including constants
  if (!prior_only) {
    // initialize linear predictor term
    vector[N] mu = rep_vector(0.0, N);
    mu += X * b;
    target += binomial_logit_lpmf(Y | trials, mu);
    if (use_proxy) {
      target += normal_lpdf(z | b[target_task_id], proxy_sd);
    }
  }
  // priors including constants
  target += lprior;
}
generated quantities {
}

