function [X,histroy,ts] = PADM_L0PCA(A,mu,r,X,max_iter,time_limit,HandleTrueObj)
% min_{X} trace(X'AX) + mu*||X||_0, X is orth
% min_{X} trace(Y'AY) + mu*||X||_0, X = Y, Y is orth
% L(X,Y,pi) = trace(Y'AY) + mu*||X||_0 + <X-Y,Pi> + 0.5 beta ||X-Y||_F^2, s.t. Y is orth
ts = []; histroy = [];
t00000 = clock();

cur_t = etime(clock(),t00000);
ts = [ts;cur_t];
histroy = [histroy;HandleTrueObj(X)];

normA = norm(A);% normA = abs(laneig((A+A')/2,1));
rho = 100;
Pi = randn(size(X))*0;
Y =  X   ;

for iter = 1:max_iter
    
    X = prox_l0(Y-Pi/rho,mu/rho);
    X = max(min(X,100),-100);% This is to avoid unbounded solutions for some extreme cases!
    
    
    O = X + Pi/rho;
    L = 2*normA + rho;
    grad = 2*A*Y + rho*(Y-O);
    Y = OrthProj(Y - grad/L);
    if ~mod(iter,30)
        rho = min(1e10,rho * 2);
    end
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    histroy = [histroy;HandleTrueObj(X)];
    if (cur_t > time_limit)
        break;
    end
end





