import numpy as np
import scipy.io as sio
import pickle
import glob

from scipy import stats
import os

from collections import Counter
import collections

class_names = ['airport_terminal', 'amphitheater', 'assembly_line', 'bamboo_forest', 'banquet_hall', 'basement', 'beach', 'boxing_ring', 'bus_interior', 'canal-natural', 'canyon', 'classroom', 'cliff', 'corn_field', 'department_store', 'desert-sand', 'dining_room', 'forest_path', 'glacier', 'greenhouse-indoor', 'gymnasium-indoor', 'jail_cell', 'museum-indoor', 'phone_booth', 'railroad_track', 'sauna', 'subway_station-platform', 'water_park', 'wind_farm', 'zen_garden']

IM = sio.loadmat('Trained_Models/Medium_sized_backbone/Scene_Classification/Psychophysics_data/information_matrix.mat')['information_matrix']

C1_L = np.array([12, 22, 23, 8, 21, 26, 9, 27, 1, 6, 17, 3, 20, 5, 15])
C2_L = np.array([7, 10, 19, 11, 13, 16, 4, 14, 18])
C3_L = np.array([25, 2, 28, 29, 30, 24])

''' Removed KH as experiment was unfinished '''
num_participants = 22
num_classes = 30

flag_debug = False
flag_debug_2 = False
flag_binarize = False

''' File containing CNN output data '''
#with open('L66_info_dict.pkl','rb') as input_file:
#flag_fullres = True #False 
flag_compute_PC = False #True

fix_lim = 4
from prettytable import PrettyTable
table = PrettyTable()
#table.field_names = ["Subject", "H-C", "AH-C", "MH-C", "Agreement-0", "Agreement-1", "Agreement-2", "Agreement-3"]
#table.field_names = ["Subject", "Pearson Correlation"]#, "Agreement-0"]
table.field_names = ["#Fixation", "Condition", "Accuracy", "Mean Agreement", "Stderr Agreement"]#, "Agreement-0"]






#valid_subset = np.load('Stats_Files/valid_subset.npy')



''' Moderate flag '''
flag_moderate = False #True




def Convert_FC(fine_class):
    #print('fine_class: {}'.format(fine_class))
    coarse_class = fine_class
    #if fine_class in C1_L: coarse_class = 0  #if fine_class in C2_L: coarse_class = 1  #if fine_class in C3_L: coarse_class = 2 #return coarse_class
    return fine_class-1

pkl_folder = 'Generated_results/Medium_sized_backbone/Scene_Classification/pkl_files/'

for curr_fixation in [0]: #range(2):
    if curr_fixation==1:
        table.add_row(["---------", "---------", "---------", "---------", "---------"])

    'Which type of agreement to compute? 0 - Human-Foveated, 1 - Human-Full_res'
    for flag_fullres_ in [0,1]: #range(6):


            if flag_fullres_==0:
                flag_fullres = False
                test_type  = 'Human-Foveated : Fix#1: Human, Fix#2: Guided'
                single_participant = [pkl_folder+'Guided_Fix_6.pkl']
                #single_participant = ['OLD_data/pkl_files/Guided_Fix_6_L111_info_dict.pkl']
                print('\n\n Human-Foveated_model')
            elif flag_fullres_==1:
                flag_fullres = True
                test_type  = 'Human-Full_resolution_model'
                single_participant = [pkl_folder+'fs_Fix_1.pkl']
                #single_participant = ['OLD_data/Generated_files/Fix_fs_6_L111_info_dict.pkl']
                print('\n\n Human-Full_resolution_model')
            elif flag_fullres_==2:
                flag_fullres = False
                test_type  = 'Human-Foveated : Fix#1: Random, Fix#2: Random'
                print('\n\n Human-Foveated_model')
                single_participant = ['pkl_files/Init_Rand_Fix_6_L111_info_dict_Run_1.pkl']
            elif flag_fullres_==3:
                flag_fullres = False
                test_type  = 'Human-Foveated : Fix#1: Human, Fix#2 : Random'
                print('\n\n Human-Foveated_model')
                single_participant = ['pkl_files/Random_Fix_6_L111_info_dict_Run_1.pkl']
            elif flag_fullres_==4:
                flag_fullres = False
                test_type  = 'Human-Foveated : Fix#1: Human, Fix#2 : Center'
                print('\n\n Human-Foveated_model')
                single_participant = ['pkl_files/Center_Fix_6_L111_info_dict.pkl']
            elif flag_fullres_==5:
                flag_fullres = False
                test_type  = 'Human-Foveated : Fix#1: Center, Fix#2 : Center'
                print('\n\n Human-Foveated_model')
                single_participant = ['pkl_files/Init_Center_Fix_6_L111_info_dict.pkl']




            global_aggm_arr = []
            global_aggm_std_arr = []
            global_HCP_arr = []
            global_participants = ['TL_SCC', 'EV_SCC', 'WH_SCC', 'AB_SCC', 'GG_SCC', 'RP_SCC', 'MC_SCC', 'AW_SCC', 'JL_SCC', 'IT_SCC', 'TB_SCC', 'CG_SCC', 'JC_SCC', 'AA_SCC', 'CMS_SCC', 'YL_SCC', 'BP_SCC', 'CS_SCC', 'CSS_SCC', 'BE_SCC', 'SL_SCC', 'EB_SCC'] #os.listdir('pkl_files/'):
            #if flag_fullres:
            #    single_participant = ['Generated_files/Fix_fs_6_L111_info_dict.pkl']
            #else:
            #    single_participant = ['V2_Generated_files/Fix_fov_6_L111_info_dict.pkl']
                #single_participant = ['V2_Generated_files/RAND_Fix_fov_6_L111_info_dict.pkl']



            #subject_index = 2
            #for fname_ in global_participants:
            #    fname = 'Psychophysics_data/pkl_files/Follow_'+fname_+'_Fix_6_L111_info_dict.pkl'

            subject_index=0
            for fname_ in single_participant: #['Fix_fov_L15_info_dict.pkl']: #os.listdir('pkl_files/'):
                fname = fname_ #'pkl_files/'+fname_
                print('fname: {}'.format(fname))

                subject_index += 1
                with open(fname,'rb') as input_file:
                  OV = pickle.load(input_file)
                  
                #print('OV.keys(): {} ({})'.format(OV.keys(), len(OV.keys())))

                correct = np.zeros((num_classes,6))
                total = np.zeros((num_classes,6))  
                ''' final_matrix: 0-num_fixations, 1-target_prob, 2-prediction, 3:-participant decisions '''
                final_matrix = np.zeros((360,3+num_participants)) 
                ''' pred_matrix: 0-gt, 1-prediction 0, 2-prediction 1, 3-prediction 2, 4-prediction 3, 5:-participant raw response '''
                pred_matrix = np.zeros((360,5+num_participants))
                pred_matrix_prob = np.zeros((360,5+num_participants))
                print('Shape of information matrix: {}'.format(IM.shape))

                for mat_idx in range(IM.shape[0]):
                  img_info = OV[mat_idx]
                  #print(img_info)
                  num_fix = int(IM[mat_idx][0])
                  #print(num_fix)
                  final_matrix[mat_idx,0] = num_fix
                  # What was the response of the model for those many fixations?
                  if not flag_fullres:
                      final_matrix[mat_idx,1] = img_info['target_prob'][num_fix]
                      tg_class = Convert_FC(img_info['target'][num_fix]+1)
                      pred_cls = Convert_FC(img_info['prediction'][num_fix]+1)
                  else:
                      final_matrix[mat_idx,1] = img_info['target_prob'][0]
                      tg_class = Convert_FC(img_info['target'][0]+1)
                      pred_cls = Convert_FC(img_info['prediction'][0]+1)

                  #if Convert_FC(img_info['prediction'][num_fix]+1)==tg_class:
                  'Correct / incorrect is stored in final_matrix[:,2]'
                  if pred_cls==tg_class:
                    correct[tg_class,num_fix]+=1
                    final_matrix[mat_idx,2] = 1
                  else:
                    final_matrix[mat_idx,2] = 0
                  total[tg_class, num_fix]+=1
                  pred_matrix[mat_idx, 0] = Convert_FC(img_info['target'][0] + 1)
                  #for n_fix in range(fix_lim+1):
                  for n_fix in range(num_fix+1):
                      #print(n_fix)
                      if not flag_fullres:
                          pred_matrix[mat_idx, n_fix+1] = Convert_FC(img_info['prediction'][n_fix]+1)
                          pred_matrix_prob[mat_idx, n_fix+1] = img_info['pred_prob'][n_fix]
                      else:
                          pred_matrix[mat_idx, n_fix+1] = Convert_FC(img_info['prediction'][0]+1)
                          pred_matrix_prob[mat_idx, n_fix+1] = img_info['pred_prob'][0]



                PC = np.divide(correct[:,:4], total[:,:4])

                ''' Compute the CNN PC for data coming from fixation 1-4'''
                valid_idx = final_matrix[:,0]<4 #or final_matrix[:,0]==1 or final_matrix[:,0]==2 or final_matrix[:,0]==3
                #CNN_response = final_matrix[valid_idx, 2]
                target_class = pred_matrix[valid_idx, 0]
                #print('CNN_response.shape: {}, np.mean(): {}'.format(CNN_response.shape, np.mean(CNN_response)))
                PC_all, PC_subset = [], []
                for fix_idx in range(2):#fix_lim):
                    '''
                    CNN_pred = pred_matrix[valid_idx, fix_idx+1]
                    correct = 0
                    for img_idx in range(CNN_pred.shape[0]):
                        if CNN_pred[img_idx]==target_class[img_idx]:
                            correct+=1
                    PC= correct/CNN_pred.shape[0]
                    PC_all.append(int(PC*100)/100)
                    #print('****** fixation: {}, PC: {}'.format(fix_idx, PC))

                    CNN_pred_ = pred_matrix[valid_idx_, fix_idx+1]
                    target_class_ = pred_matrix[valid_idx_, 0]
                    #print('Only this fixation img: {}'.format(CNN_pred_.shape[0]))
                    correct = 0
                    for img_idx in range(CNN_pred_.shape[0]):
                        if CNN_pred_[img_idx]==target_class_[img_idx]:
                            correct+=1
                    PC= correct/CNN_pred_.shape[0]
                    #print('###### fixation: {}, PC: {}'.format(fix_idx, PC))
                    PC_subset.append(int(PC*100)/100)

                    PC = np.mean(final_matrix[valid_idx_,2])
                    print('Basing on final_matrix: {}: {:.2f}'.format(fix_idx, PC))
                    '''
                    valid_idx_ = final_matrix[:,0]==fix_idx #or final_matrix[:,0]==1 or final_matrix[:,0]==2 or final_matrix[:,0]==3
                    gt = pred_matrix[valid_idx_,0]
                    resp = pred_matrix[valid_idx_,fix_idx+1]
                    PC = np.mean(gt==resp)
                    print('Basing on pred_matrix: {}: {:.2f}'.format(fix_idx, PC))
                    PC_subset.append(int(PC*100)/100)
                #print('\n\nCNN performance \nConsidering all images: {}'.format(PC_all))
                print('Considering only a subset of images: {}'.format(PC_subset))


                # Copy the human data into the same matrix
                ''' Human data'''
                col_idx = 2
                mat_names = []
                #for mat_name in glob.glob('MAT_Data/*.mat'):
                for subj_name in global_participants: #os.listdir('MAT_Data'): #for fix_idx in np.arange(6,7):#6):
                    mat_name = 'Trained_Models/Medium_sized_backbone/Scene_Classification/Psychophysics_data/MAT_Data/'+subj_name+'.mat'
                    col_idx+=1
                    #print('{} :  {}'.format(col_idx, subj_name))
                    mat_names.append(mat_name.split('/')[1].split('.')[0])
                    #print('col_idx: {}, Human#{}, {}'.format(col_idx, col_idx-2, mat_name.split('/')[1].split('.')[0]))
                    Z = sio.loadmat(mat_name)
                    response = Z['response']
                    stimshown = Z['stimshown']
                    for stim_idx in range(stimshown.shape[1]):
                        curr_idx = stimshown[0,stim_idx]-1
                        resp = Convert_FC(response[0,stim_idx])
                        gt = Convert_FC(int(IM[curr_idx,1]))
                        if gt==resp:
                            final_matrix[curr_idx, col_idx] = 1
                        pred_matrix[curr_idx, col_idx+2] = resp 
                #print(mat_names)
                if flag_debug:
                    print('\n\nHuman performance \npred_matrix: {}'.format(pred_matrix.shape))
                for fix_idx in range(curr_fixation,curr_fixation+1):
                    valid_idx_ = final_matrix[:,0]==fix_idx
                    if flag_moderate:
                        valid_idx_ = np.logical_and(valid_idx_,valid_subset)
                    #print(valid_idx_)
                    PC_hum = []
                    Agreement = []
                    Chance_Agreement = []
                    Norm_Agreement = []
                    for col_idx in np.arange(5,pred_matrix.shape[1]):
                        gt = pred_matrix[valid_idx_,0]
                        human_resp = pred_matrix[valid_idx_,col_idx]
                        PC_hum.append(int(np.mean(gt==human_resp)*100)/100)
                        model_resp = pred_matrix[valid_idx_,fix_idx+1]

                        'Compute agreement between model and human'
                        model_gt = model_resp==gt
                        human_gt = human_resp==gt
                        agreement = np.mean(model_gt==human_gt)
                        Agreement.append(int(agreement*100)/100)

                        'Compute chance performance'
                        model_pc = np.mean(model_resp==gt)
                        human_pc = np.mean(human_resp==gt)
                        chance_agreement = model_pc*human_pc + (1-model_pc)*(1-human_pc)
                        Chance_Agreement.append(int(chance_agreement*100)/100)

                        'Compute normalized agreement'
                        norm_agreement = (agreement-chance_agreement)/(1-chance_agreement)
                        Norm_Agreement.append(int(norm_agreement*1000)/1000)
                        #print('****** {}'.format(np.sum(valid_idx)))
                        #print('PREDICTION_MATRIX: col_idx: {}, pred_matrix: {}'.format(col_idx, np.mean(pred_matrix[:,col_idx]==pred_matrix[:,0])))
                        #PC_hum.append(np.mean(pred_matrix[valid_idx,col_idx]==pred_matrix[valid_idx,0]))
                    if flag_debug:
                        print('{}: Human PC: {}, Mean: {}, STD: {}'.format(fix_idx, len(PC_hum), np.mean(PC_hum), np.std(PC_hum)))

                #'''
                    #print('model_resp: {}, gt: {}, model_resp==gt: {}'.format(model_resp, gt, model_resp==gt))
                    print('fix_idx: {}, PC_human: {}, model_pc: {}, \nAgreement: {},  \nChance Agreement: {}, \nNorm Agreement: {} ({} - {})'.format(fix_idx, PC_hum, model_pc, Agreement, Chance_Agreement, Norm_Agreement, np.mean(Norm_Agreement), np.std(Norm_Agreement)/np.sqrt(22)))
                    table.add_row([curr_fixation, test_type, PC_subset[curr_fixation], int(1000*np.mean(Norm_Agreement))/1000, int(1000*np.std(Norm_Agreement)/np.sqrt(22))/1000])
                #continue


    test_type = 'Human-Human'
    print('\n\n'+test_type)
    for fix_idx in range(curr_fixation,curr_fixation+1):
        valid_idx_ = final_matrix[:,0]==fix_idx
        if flag_moderate:
            valid_idx_ = np.logical_and(valid_idx_,valid_subset)
        #print(valid_idx_)
        PC_hum = []
        Agreement = []
        Chance_Agreement = []
        Norm_Agreement = []
        PC_arr = []
    for col_idx in np.arange(5,pred_matrix.shape[1]):
        gt = pred_matrix[valid_idx_,0]
        human_resp = pred_matrix[valid_idx_,col_idx]
        PC_arr.append(int(np.mean(gt==human_resp)*100)/100)
        for col_idx_N in np.arange(col_idx+1,pred_matrix.shape[1]):
            PC_hum.append(int(np.mean(gt==human_resp)*100)/100)
            model_resp = pred_matrix[valid_idx_, col_idx_N]

            'Compute agreement between model and human'
            model_gt = model_resp==gt
            human_gt = human_resp==gt
            agreement = np.mean(model_gt==human_gt)
            Agreement.append(int(agreement*100)/100)

            'Compute chance performance'
            model_pc = np.mean(model_resp==gt)
            human_pc = np.mean(human_resp==gt)
            chance_agreement = model_pc*human_pc + (1-model_pc)*(1-human_pc)
            Chance_Agreement.append(int(chance_agreement*100)/100)

            'Compute normalized agreement'
            norm_agreement = (agreement-chance_agreement)/(1-chance_agreement)
            Norm_Agreement.append(int(norm_agreement*1000)/1000)
            #print('****** {}'.format(np.sum(valid_idx)))
            #print('PREDICTION_MATRIX: col_idx: {}, pred_matrix: {}'.format(col_idx, np.mean(pred_matrix[:,col_idx]==pred_matrix[:,0])))
    print('length: {}'.format(len(Norm_Agreement)))
    print('Human PC: {}'.format(PC_arr))
    print('Norm_Agreement: {}  ({} - {})'.format(Norm_Agreement, np.mean(Norm_Agreement), np.std(Norm_Agreement)/np.sqrt(len(Norm_Agreement))))
    table.add_row([curr_fixation, test_type, [int(1000*np.mean(PC_arr))/1000, int(1000*np.std(PC_arr)/np.sqrt(len(PC_arr)))/1000], int(1000*np.mean(Norm_Agreement))/1000, int(1000*np.std(Norm_Agreement)/np.sqrt(len(Norm_Agreement)))/1000])
    print(table)



























'''
            def RA(inp_arr):
                #print('RA: in_arr.shape: {}'.format(inp_arr.shape))
                assert inp_arr.shape[0]==30
                out_arr = np.array([np.mean(inp_arr[C1_L-1]), np.mean(inp_arr[C2_L-1]), np.mean(inp_arr[C3_L-1])])

                #return out_arr
                return inp_arr


            def TA(inp_arr, corr_class):
                assert inp_arr.shape==corr_class.shape
                #print('corr_class: {}'.format(corr_class))

                out_arr = []
                for class_idx in range(30):
                    v_idx = corr_class==class_idx
                    out_arr.append(np.mean(inp_arr[v_idx]))

                out_arr =  np.array(out_arr)

                return RA(out_arr)



            F_HHM = []
            F_HHE = []
            F_HCM = []
            F_HCE = []
            F_AHC = []
            F_MHC = []
            Maj_Human_PCs = []
            Avg_Human_PCs = []
            CNN_PCs = []
            aggm_arr = [] # Store agreements in this array
            HCP_corr_arr = [] # Store agreements in this array
            aggm_arr_std = [] # Store agreements in this array
            Y_HC = []
            for num_fix in np.arange(0,1):#1,2):
                valid_idx = final_matrix[:,0]==num_fix
                corr_class = pred_matrix[:, 0][valid_idx]
                if True:#flag_debug:
                    #print('\n\nfixations: {} corr_class: {}'.format(num_fix, corr_class))
                    print('\n\nfixations: {}'.format(num_fix))
                    print('with corresponding fixations: {}'.format(np.sum(final_matrix[valid_idx][:,2])))

                CNN_out = final_matrix[valid_idx][:,2]
                'CNN_out = pred_matrix[valid_idx][:,num_fix+1]'
                #CNN_out = pred_matrix_prob[valid_idx][:,2]
                CNN_final = CNN_out #final_matrix[valid_idx][:,2]

                if flag_debug:
                    print('***** CNN_final: shape: {},   sum: {},  data: {}'.format(CNN_final.shape, np.sum(CNN_final), CNN_out))
                    print('***** CNN_modified: shape: {},   data: {}'.format(np.array(TA(CNN_final,corr_class)).shape, np.array(TA(CNN_final,corr_class))))

                h_perf = []
                aggm = []
                for col_idx in np.arange(3,3+num_participants):
                    Human_out = final_matrix[valid_idx][:,col_idx]
                    'Human_out = pred_matrix[valid_idx][:,col_idx+2]'
                    h_perf.append(np.mean(Human_out))

                    if subject_index==1:
                        if flag_debug_2:
                            print('Human predictions: {} ---- {}'.format(col_idx+2, pred_matrix[valid_idx][:,col_idx+2])) 
                            print('CNN predictions: {} ---- {}'.format(num_fix+1, pred_matrix[valid_idx][:,num_fix+1]))
                        GT_humans = (corr_class==pred_matrix[valid_idx][:,col_idx+2]).astype(int)
                        if flag_debug_2:
                            print('GT==humans: {}'.format(GT_humans))
                            print('Disagreements: {}'.format([class_names[int(x)]   for x in  corr_class[GT_humans==0]]))
                        GT_CNN = (corr_class==pred_matrix[valid_idx][:,num_fix+1]).astype(int)
                        if flag_debug_2:
                            print('GT==CNN: {}'.format(GT_CNN))
                            print('Disagreements: {}'.format([class_names[int(x)]   for x in  corr_class[GT_CNN==0]]))
                        if flag_binarize:
                            humans_CNN = (GT_humans==GT_CNN).astype(int)
                        else:
                            humans_CNN = (pred_matrix[valid_idx][:,col_idx+2]==pred_matrix[valid_idx][:,num_fix+1]).astype(int)
                        if flag_debug_2:
                            print('------ {}: humans_CNN: {} --> {:.2f}%'.format(global_participants[col_idx-3], humans_CNN, 100*np.sum(humans_CNN)/60))
                            print('Disagreements: {}'.format([class_names[int(x)]   for x in  corr_class[humans_CNN==0]]))
                        if flag_compute_PC:
                            aggm.append(int(100*np.sum(GT_CNN)/humans_CNN.shape[0])/100)
                        else:
                            aggm.append(int(100*np.sum(humans_CNN)/humans_CNN.shape[0])/100)


                if flag_debug:
                    print('***** Human_final: shape: {},   data: {},  Agreement: {:.2f} ({})'.format(np.array(h_perf).shape, np.array(h_perf), np.mean(aggm), aggm))
                if subject_index==1:
                    print('@@@@@@@@@@@@@@@@@ aggm: {}'.format(aggm))
                    'Mean and std across participants is in the arrays below --> 4 values at the end of 4 fixations'
                    aggm_arr.append(int(100*np.mean(aggm))/100)
                    #aggm_arr_std.append(int(1000*np.std(aggm)/np.sqrt(len(aggm)))/1000)
                    aggm_arr_std.append(int(1000*np.std(aggm))/1000)
                else:
                    if flag_debug:
                        print('$$$$$$$$ final_matrix.shape: {}, subject_index: {}'.format(final_matrix.shape, subject_index))
                    'Human_out = final_matrix[valid_idx][:,subject_index]'
                    'Human_out = pred_matrix[valid_idx][:,subject_index+2]'
                    #if flag_debug:
                    #    print('{}: Human_out: {},  sum: {},   data: {}, Agreement: {}'.format(col_idx-3, Human_out.shape, np.sum(Human_out), Human_out, np.sum(CNN_out==Human_out)))
                    print('Ground truth: {}'.format(corr_class)) 
                    print('Human predictions: {} ---- {}'.format(subject_index+2, pred_matrix[valid_idx][:,subject_index+2])) 
                    print('Human-guided CNN predictions: {} ---- {}'.format(num_fix+1, pred_matrix[valid_idx][:,num_fix+1]))
                    GT_humans = (corr_class==pred_matrix[valid_idx][:,subject_index+2]).astype(int)
                    print('GT==humans: {}'.format(GT_humans))
                    print('Disagreements: {}'.format([class_names[int(x)]   for x in  corr_class[GT_humans==0]]))
                    GT_CNN = (corr_class==pred_matrix[valid_idx][:,num_fix+1]).astype(int)
                    print('GT==CNN: {}'.format(GT_CNN))
                    print('CNN_out: {} ({})'.format(CNN_final, np.sum(CNN_final==GT_CNN)))
                    print('Disagreements: {}'.format([class_names[int(x)]   for x in  corr_class[GT_CNN==0]]))
                    if flag_binarize:
                        humans_CNN = (GT_humans==GT_CNN).astype(int)
                    else:
                        humans_CNN = (pred_matrix[valid_idx][:,subject_index+2]==pred_matrix[valid_idx][:,num_fix+1]).astype(int)
                    print('------ {}: humans_CNN: {} --> {:.2f}%'.format(global_participants[subject_index-3], humans_CNN, 100*np.sum(humans_CNN)/60))
                    print('Disagreements: {}'.format([class_names[int(x)]   for x in  corr_class[humans_CNN==0]]))
                    if flag_compute_PC:
                        aggm_arr.append(int(100*np.sum(GT_CNN)/humans_CNN.shape[0])/100)
                    else:
                        aggm_arr.append(int(100*np.sum(humans_CNN)/humans_CNN.shape[0])/100)

                Average_Human_ = final_matrix[valid_idx]
                Average_Human = np.mean(Average_Human_[:,3:], axis=1)
                if flag_debug:
                    print('Average human.shape: {} ({})'.format(Average_Human.shape, np.sum(Average_Human)))
                Majority_Human_ = final_matrix[valid_idx]
                Majority_Human = np.floor(np.sum(Majority_Human_[:,3:], axis=1)>11)#.astype(np.int32).tolist()
                if flag_debug:
                    print('Majority human.shape: {} ({})'.format(Majority_Human.shape, np.sum(Majority_Human)))

                CNN_PCs.append([int(MH*100)/100    for MH in TA(CNN_final,corr_class)])
                Maj_Human_PCs.append([int(MH*100)/100    for MH in TA(Majority_Human,corr_class)])
                Avg_Human_PCs.append([int(MH*100)/100    for MH in TA(Average_Human,corr_class)])
                ' Human-Human correlation '
                HCP_corr = []
                HCS_corr = []
                HHP_corr = []
                HHS_corr = []
                for src_col in np.arange(3,3+num_participants):
                    src_data = final_matrix[valid_idx][:,src_col]
                    ' Correlation of single human with CNN '
                    PC, p = stats.pearsonr(TA(src_data,corr_class), TA(CNN_out,corr_class))     #SC, p = stats.spearmanr(src_data, CNN_out)
                    if subject_index==1:
                        HCP_corr.append(PC)   #HCS_corr.append(SC)
                    else:
                        if subject_index==src_col:
                            HCP_corr_arr.append(PC)   #HCS_corr.append(SC)

                    #print('Individual CNN-Human correlation, name: {}, Pearson: {}, Spearman: {}'.format(mat_names[src_col-3], PC, SC))
                    #print('Individual CNN-Human correlation, name: {}, Pearson: {}'.format(mat_names[src_col-3], PC))
                    for dest_col in np.arange(src_col+1,3+num_participants):
                        dest_data = final_matrix[valid_idx][:,dest_col]
                        ' Correlation between human and human'
                        PC, p = stats.pearsonr(TA(src_data,corr_class), TA(dest_data,corr_class))  #SC, p = stats.spearmanr(src_data, dest_data)
                        HHP_corr.append(PC)  #HHS_corr.append(SC)
                HHP_corr = np.array(HHP_corr)   #HHS_corr = np.array(HHS_corr)
                HHP_corr_M = np.mean(HHP_corr)
                HHP_corr_E = np.std(HHP_corr) #/np.sqrt(HHP_corr.shape[0])   #HHS_corr_M = np.mean(HHS_corr)    HHS_corr_E = np.std(HHS_corr)/np.sqrt(HHS_corr.shape[0])
                F_HHM.append(int(HHP_corr_M*100)/100)
                F_HHE.append(int(HHP_corr_E*100)/100)
                if True: # #flag_debug:
                    print('Correlation of Human-Human:  Pearsonr: {} ({}) \nraw data= {}'.format(HHP_corr_M, HHP_corr_E, (100*HHP_corr).astype(int)/100  ))
                if subject_index==1:
                    HCP_corr = np.array(HCP_corr)  #HCS_corr = np.array(HCS_corr)
                    HCP_corr_M = np.mean(HCP_corr)
                    HCP_corr_E = np.std(HCP_corr) #/np.sqrt(HCP_corr.shape[0])    #HCS_corr_M = np.mean(HCS_corr) HCS_corr_E = np.std(HCS_corr)/np.sqrt(HCS_corr.shape[0])
                    F_HCM.append(int(HCP_corr_M*1000)/1000)
                    F_HCE.append(int(HCP_corr_E*1000)/1000)
                    if True: #flag_debug:
                        print('Correlation of Human-CNN:  Pearsonr: {} ({}), \n HCP_corr = {}'.format(HCP_corr_M, HCP_corr_E, (100*HCP_corr).astype(int)/100 ))
                    Y_HC.append((100*HCP_corr).astype(int)/100 )
                Pearson_C, p = stats.pearsonr(TA(CNN_out,corr_class), TA(Average_Human,corr_class))    #Spearman_C, p = stats.spearmanr(CNN_out, Average_Human)
                F_AHC.append(int(Pearson_C*100)/100)
                if flag_debug:
                    print('Correlation of CNN-Avg.Human:  Pearsonr: {}'.format(Pearson_C))
                Pearson_C, p = stats.pearsonr(TA(CNN_out,corr_class), TA(Majority_Human,corr_class))  #Spearman_C, p = stats.spearmanr(CNN_out, Majority_Human)
                F_MHC.append(int(Pearson_C*100)/100)
                if flag_debug:
                    print('Correlation of CNN-Majority_Human:  Pearsonr: {}'.format(Pearson_C))
            table.add_row([test_type, F_HCM[0]])#, aggm_arr[0]])
            print('Human - CNN std error: {}'.format(F_HCE))
            global_aggm_arr.append(aggm_arr)
            #global_aggm_std_arr.append(aggm_arr_std)
            global_HCP_arr.append(HCP_corr_arr)
            tmp_arr = np.array(global_HCP_arr)
            print('***** tmp_arr.shape: {}'.format(tmp_arr.shape))
            #break

        #print(table)
        print(subject_index)
        if subject_index==1:
            print('\n\nHCP: Before matching eye-movements: {} ({})'.format(F_HCM, F_HCE))
            print('Agreement/PC: Before matching eye-movements: {} ({})'.format(aggm_arr, aggm_arr_std))
        else:
            global_aggm_arr = np.array(global_aggm_arr)
            #global_aggm_std_arr = np.array(global_aggm_std_arr)
            print('global_aggm_arr.shape: {}, {}'.format(global_aggm_arr.shape, global_aggm_arr))
            global_HCP_arr = np.array(global_HCP_arr)
            print('global_HCP_arr.shape: {}, {}'.format(global_HCP_arr.shape, global_HCP_arr))
            print('\n\nHCP: After matching eye-movements: Mean: {} ({})'.format(np.mean(global_HCP_arr,axis=0) , (1000*np.std(global_HCP_arr,axis=0)).astype(int)/1000  ))
            print('Agreement/PC: After matching eye-movements: Mean: {} ({})'.format(np.mean(global_aggm_arr,axis=0),  (1000*np.std(global_aggm_arr,axis=0)).astype(int)/1000  ))

table.add_row(['Human-Human correlation', int(1000*HHP_corr_M)/1000])
print(table)
'''
