import numpy as np

num_fixations = 3 #5 #2 #3
flag_backbone = 'Medium' #'Large'

if flag_backbone=='Medium':
  FPS = [3820, 2307, 1506, 1182, 923] #[1.15, 1.83, 2.71, 3.79, 5.07]
  FPS_fs = 1229 #5.25 
  FS = np.load('Generated_results/Medium_sized_backbone/Dynamic_Stop/FullRes/Individual_stats.npy')
  Fov = np.load('Generated_results/Medium_sized_backbone/Dynamic_Stop/Foveated/50_5_center/Individual_stats.npy')
else:
  FPS = [1.57, 2.25, 3.13, 4.21, 5.49]
  FPS_fs = 5.67 
  FS = np.load('Generated_results/Large_sized_backbone/Dynamic_Stop/FullRes/Individual_stats.npy')
  Fov = np.load('Generated_results/Large_sized_backbone/Dynamic_Stop/Foveated/70_5_center/Individual_stats.npy')

tot_cnt = 50000


flag_ensemble = True #False #True #False

stopped = np.zeros(50000)
Stopped = []
Correct = 0 #[]
#Correct_5 = []
for fix_idx in range(num_fixations):
  # Decide anyway
  stopped += Fov[:,25+fix_idx]
  Stopped.append(np.sum(Fov[:,25+fix_idx]))
  s_idx = Fov[:,25+fix_idx]==1
  print('######fix_idx: {}, decide anyway: {}, decide among stopped: {}'.format(fix_idx, np.sum(Fov[:, 20+fix_idx]), np.sum(Fov[s_idx, 20+fix_idx])   ))
  #Correct.append(np.sum(Fov[s_idx,31]))
  #print('fix_idx: {}/{} stopped: {}, correct: {}'.format(fix_idx, num_fixations, np.sum(s_idx), int(np.sum(Fov[s_idx,31])/100)))
  #Correct_5.append(np.sum(Fov[s_idx,32]))
  Correct += np.sum(Fov[s_idx, 20+fix_idx])
stopped_idx = stopped==1
not_stopped_idx = stopped==0
#print(Correct)
print('After fixations: Correctly stopped: {},  stopped: {}'.format(Correct, np.sum(stopped)))




print('######fix_idx: {}, LEFT: {}, decide anyway among left: {}, decide among not stopped: (Fov: {}, FS: {})'.format(num_fixations-1, np.sum(not_stopped_idx), np.sum(Fov[:, 20+num_fixations-1]), np.sum(Fov[not_stopped_idx, 20+num_fixations-1]), np.sum(FS[not_stopped_idx, 31]/100)   ))


corr_1_fs  = np.sum(FS[:, 31])
corr_5_fs  = np.sum(FS[:, 32])
if flag_ensemble:
    print('not_stopped: {}'.format(np.sum(not_stopped_idx)))
    corr_1_fov = np.sum(Fov[stopped_idx, 31]) + np.sum(FS[not_stopped_idx, 31])
    corr_5_fov = np.sum(Fov[stopped_idx, 32]) + np.sum(FS[not_stopped_idx, 32])
else:
    corr_1_fov = np.sum(Fov[:, 31]) #+ np.sum(FS[not_stopped_idx, 31])
    corr_5_fov = np.sum(Fov[:, 32]) #+ np.sum(FS[not_stopped_idx, 32])
#print('\n\nAcc@1: {:.2f}, Acc@5: {:.2f}'.format(np.sum(Fov[:, 31])/50000, np.sum(Fov[:, 32])/50000))
print('\n\nFov: Acc@1: {:.2f}, Acc@5: {:.2f}'.format(np.sum(corr_1_fov)/tot_cnt, np.sum(corr_5_fov)/tot_cnt))
print('FS:  Acc@1: {:.2f}, Acc@5: {:.2f}'.format(np.sum(corr_1_fs)/tot_cnt, np.sum(corr_5_fs)/tot_cnt))

rest = tot_cnt-np.sum(np.array(Stopped))
if flag_ensemble:
  FPS_Ensemble = 1/((1/FPS[num_fixations-1])+(1/FPS_fs))
  #FPS_Ensemble = FPS[num_fixations-1]+FPS_fs
else:
  FPS_Ensemble = FPS[num_fixations-1]
#print('Total: {}+ {}, rest: {}, With FS FPS: {}'.format(np.sum(stopped_idx),np.sum(not_stopped_idx),rest, FPS_Ensemble))

# compute time-taken
Time = 0
for fix_idx in range(num_fixations):
  Time += Stopped[fix_idx]/FPS[fix_idx]
  #Time += Stopped[fix_idx]*FPS[fix_idx]

# Time for rest of images
#if USE_FS==0:
if flag_ensemble:
  Correct += np.sum(FS[not_stopped_idx, 31])/100
else:
  Correct += np.sum(Fov[not_stopped_idx, 20+num_fixations-1])

#Fov_Correct = np.sum(Correct) + np.sum(Fov[not_stopped_idx, 20+num_fixations-1]) #2324 #6787
#Fov_Correct_5 = np.sum(Correct_5) + np.sum(Fov[not_stopped_idx, 32]) #2324 #6787
#print('\nAfter fixations: Remaining: Correct (notstopped): {} ({})'.format(int(np.sum(Fov[not_stopped_idx, 20+num_fixations-1])/100), np.sum(not_stopped_idx)))
#print('\nAfter fixations: Remaining: Correct (notstopped): {} ({})'.format(int(np.sum(Fov[not_stopped_idx, 31])/100), np.sum(not_stopped_idx)))
#else:
print('\n\n####Correct: {}'.format(Correct))

if flag_ensemble:
  FS_Time = Time + rest/FPS_Ensemble
  FS_Correct = Correct #np.sum(Correct) + np.sum(FS[not_stopped_idx, 31]) #2830 #7566
  #FS_Correct_5 = np.sum(Correct_5) + np.sum(FS[not_stopped_idx, 32]) #2830 #7566
else:
  Fov_Time = Time + rest/FPS_Ensemble #FPS[num_fixations-1]
  Fov_Correct = Correct #+ np.sum(Fov[not_stopped_idx, 31]) #2324 #6787

#Fov_Accuracy_5 = Fov_Correct_5/50000

if flag_ensemble:
  FS_FPS = tot_cnt/FS_Time
  FS_Accuracy = FS_Correct/tot_cnt
else:  #FS_Accuracy_5 = FS_Correct_5/50000
  Fov_FPS = tot_cnt/Fov_Time
  Fov_Accuracy = Fov_Correct/tot_cnt

#print('\nWithout FS: FPS: {}, Acc@1: {}, Acc@5: {}'.format(Fov_FPS, Fov_Accuracy, Fov_Accuracy_5))
if flag_ensemble:
  #print('With FS: FPS: {}, Acc@1: {}, Acc@5: {}'.format(FS_FPS, FS_Accuracy, FS_Accuracy_5))
  print('With FS: fixations used: {}, FS: FPS: {}, Acc@1: {:.2f}'.format(num_fixations, FS_FPS, FS_Accuracy*100))
else:
  print('Without FS: fixations used: {}, FS: FPS: {}, Acc@1: {:.2f}'.format(num_fixations, Fov_FPS, Fov_Accuracy*100))
