from typing import List

import torch
import numpy as np

def reformat_as_torch_tensor(x, device=torch.device('cuda') if torch.cuda.is_available() else torch.device('cpu')):
    if isinstance(x, List):
        return torch.tensor(x, device=device)
    elif isinstance(x, np.ndarray):
        return torch.from_numpy(x).to(device=device)
    elif isinstance(x, torch.Tensor):
        return x.to(device=device)
    else:
        raise ValueError(f'Unsupported type: {type(x)}')
